% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UpdateKlass-graph-navigate.R
\name{update_klass_node}
\alias{update_klass_node}
\title{Given a node and a graph, find the node at the end of a sequence of changes.}
\usage{
update_klass_node(graph, node)
}
\arguments{
\item{graph}{A graph generated by \code{\link{klass_graph}}.}

\item{node}{A node as returned by \code{\link{klass_node}} or
\code{\link[igraph]{V}}.}
}
\value{
A sequence of vertices, starting with \code{node} and ending with the
  last visited node.
}
\description{
Given a node and a graph, find the node at the end of a sequence of changes.
}
\examples{

# Build a graph directed towards the most recent codes.
library(klassR)
klass_131 <- klass_graph(131)

# Find the most recent node in the graph representing the code "0101" (Halden,
# valid to 2020.)
halden_node <- klass_node(klass_131, "0101")

# Find the most recent code corresponding to 0101 Halden
halden_node_updated <- update_klass_node(klass_131, halden_node)


}
