% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ki_timeseries_list.R
\name{ki_timeseries_list}
\alias{ki_timeseries_list}
\title{Get list of available time series for station or
list of stations.}
\usage{
ki_timeseries_list(hub, station_id, ts_name, coverage = TRUE, group_id,
  return_fields)
}
\arguments{
\item{hub}{The KiWIS database you are querying. Either one of the defaults or a URL.
See \href{https://github.com/rywhale/kiwisR}{README}.}

\item{station_id}{Either a single station id or a vector of station ids. Can be string or numeric.
Station ids can be found using the ki_station_list function.}

\item{ts_name}{(Optional) A specific time series short name to search for. Supports the use of "*" as a wildcard.}

\item{coverage}{(Optional) Whether or not to return period of record columns.
Defaults to TRUE, change to FALSE for faster queries.}

\item{group_id}{(Optional) A time series group id (see ki_group_list)}

\item{return_fields}{(Optional) Specific fields to return. Consult your KiWIS hub services documentation for available options.
Should be a comma separate string or a vector.}
}
\value{
A tibble containing all available time series for selected stations.
}
\description{
Get list of available time series for station or
list of stations.
}
\examples{
\dontrun{
ki_timeseries_list(hub = "swmc", station_id = "146775")
ki_timeseries_list(hub = "swmc", ts_name = "Vel*")
}

}
