% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/revise.R
\name{kis_revise_cancel}
\alias{kis_revise_cancel}
\alias{kis_revise}
\alias{kis_cancel}
\alias{kis_cancel_all}
\title{KIS revise and cancel orders}
\usage{
kis_revise_cancel(
  order_no,
  order_branch,
  order_qty,
  order_price,
  prdt_code,
  order_dv = "00",
  cncl_dv = c("01", "02"),
  qty_all_yn = c("Y", "N")
)

kis_revise(
  order_no,
  order_branch,
  order_qty,
  order_price,
  prdt_code,
  order_dv = "00",
  cncl_dv = "01",
  qty_all_yn = c("Y", "N")
)

kis_cancel(
  order_no,
  order_branch,
  order_qty,
  order_price,
  prdt_code,
  order_dv = "00",
  cncl_dv = "02",
  qty_all_yn = c("Y", "N")
)

kis_cancel_all()
}
\arguments{
\item{order_no}{A string specifying order number}

\item{order_branch}{A string specifying branch code}

\item{order_qty}{A numeric or string specifying order quantity}

\item{order_price}{A numeric or string specifying order price}

\item{prdt_code}{A string specifying account product code}

\item{order_dv}{A string specifying limit order(00) or market order(01)}

\item{cncl_dv}{A string specifying revise(01) or cancel(02)}

\item{qty_all_yn}{A string specifying total order quantity or not}
}
\value{
A list contains rt_cd: return code, msg_cd: message code,
msg1: message

response
}
\description{
Revise and cancel orders.
}
\examples{
## revise
\dontrun{
kis_revise(
  order_no = "your order number",
  order_branch = "your order branch", order_qty = "your order quantity",
  order_price = "your order price"
)
}
## cancel
\dontrun{
kis_cancel(
  order_no = "your order number",
  order_branch = "your order branch", order_qty = "your order quantity",
  order_price = "your order price"
)
}
## cancel all
\dontrun{
kis_cancel_all()
}

}
