% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinn.R
\name{kinn.plot}
\alias{kinn.plot}
\title{Plots model graphs and (optional) saves them as files in a gml format}
\usage{
kinn.plot(gmodel, filename = NULL)
}
\arguments{
\item{gmodel}{kinn model generated from kinn function}

\item{filename}{prefix for the subgraphs files in gml format(optional)}
}
\description{
Plots model graphs and (optional) saves them as files in a gml format
}
\examples{
library(kinn)
library(caret)
x<-runif(100,min = 0,max=10)
e<-rnorm(100)
y<-2*x+3+e
df<-data.frame(x,y)
inTrain <- createDataPartition(y = df$y, p = 0.7, list = FALSE)
train <-df[inTrain, ]
test <- df[-inTrain, ]
model=kinn.train("y~x",train)
kinn.plot(model,'subgraphfile')
}

