# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' R's implementation of the Moore-Penrose pseudo matrix inverse
#' 
#' @param m matrix
#' @return matrix inverse of m
Rginv <- function(m) {
    .Call(`_kimfilter_Rginv`, m)
}

#' Generalized matrix inverse
#' 
#' @param m matrix
#' @return matrix inverse of m
gen_inv <- function(m) {
    .Call(`_kimfilter_gen_inv`, m)
}

#' Steady State Probabilities
#' 
#' Finds the steady state probabilities from a transition matrix
#' mat = |p_11 p_21 ... p_m1|
#'       |p_12 p_22 ... p_m2|
#'       |...            ...|
#'       |p_1m p_2m ... p_mm|
#' where the columns sum to 1
#' 
#' @param mat square SxS matrix of probabilities with column sums of 1. S
#' represents the number of states
#' @return matrix of dimensions Sx1 with steady state probabilities
#' @examples
#' \dontrun{
#' library(kimfilter)
#' Pm = rbind(c(0.8406, 0.0304), 
#'            c(0.1594, 0.9696))
#' ss_prob(Pm)
#' }
#' @export
ss_prob <- function(mat) {
    .Call(`_kimfilter_ss_prob`, mat)
}

#' Matrix self rowbind
#' 
#' @param mat matrix
#' @param times integer
#' @return matrix
self_rbind <- function(mat, times) {
    .Call(`_kimfilter_self_rbind`, mat, times)
}

#' Check if list contains a name
#' 
#' @param s a string name
#' @param L a list object
#' @return boolean
contains <- function(s, L) {
    .Call(`_kimfilter_contains`, s, L)
}

#' Kim Filter
#' 
#' @param ssm list describing the state space model, must include names
#' B0 - N_b x 1 x n_state array of matrices, initial guess for the unobserved components 
#' P0 - N_b x N_b x n_state array of matrices, initial guess for the covariance matrix of the unobserved components
#' Dm - N_b x 1 x n_state array of matrices, constant matrix for the state equation
#' Am - N_y x 1 x n_state array of matrices, constant matrix for the observation equation
#' Fm - N_b X p x n_state array of matrices, state transition matrix
#' Hm - N_y x N_b x n_state array of matrices, observation matrix
#' Qm - N_b x N_b x n_state array of matrices, state error covariance matrix
#' Rm - N_y x N_y x n_state array of matrices, state error covariance matrix
#' betaO - N_y x N_o x n_state array of matrices, coefficient matrix for the observation exogenous data
#' betaS - N_b x N_s x n_state array of matrices, coefficient matrix for the state exogenous data
#' Pm - n_state x n_state matrix, state transition probability matrix
#' @param yt N x T matrix of data
#' @param Xo N_o x T matrix of exogenous observation data
#' @param Xs N_s x T matrix of exogenous state 
#' @param weight column matrix of weights, T x 1
#' @param smooth boolean indication whether to run the backwards smoother
#' @return list of cubes and matrices output by the Kim filter
kim_filter_cpp <- function(ssm, yt, Xo = NULL, Xs = NULL, weight = NULL, smooth = FALSE) {
    .Call(`_kimfilter_kim_filter_cpp`, ssm, yt, Xo, Xs, weight, smooth)
}

