% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_reg_w_interaction.R
\name{logistic_reg_w_interaction}
\alias{logistic_reg_w_interaction}
\title{Logistic regression with an interaction term}
\usage{
logistic_reg_w_interaction(
  data = NULL,
  dv_name = NULL,
  iv_1_name = NULL,
  iv_2_name = NULL,
  round_p = 3,
  round_chi_sq = 2,
  dv_ordered_levels = NULL,
  iv_1_ordered_levels = NULL,
  iv_2_ordered_levels = NULL,
  one_line_summary_only = FALSE,
  p_value_interaction_only = FALSE,
  return_dt_w_binary = FALSE
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{dv_name}{name of the dependent variable (must be a binary variable)}

\item{iv_1_name}{name of the first independent variable}

\item{iv_2_name}{name of the second independent variable}

\item{round_p}{number of decimal places to which to round
p-values (default = 3)}

\item{round_chi_sq}{number of decimal places to which to round
chi square statistics (default = 2)}

\item{dv_ordered_levels}{a vector with the ordered levels of the
dependent variable, the first and second elements of which will be
coded as 0 and 1, respectively, to run logistic regression.
E.g., \code{dv_ordered_levels = c("fail", "pass")}}

\item{iv_1_ordered_levels}{(only if the first independent variable
is a binary variable) a vector with the ordered levels of the first
independent variable, the first and second elements of which will be
coded as 0 and 1, respectively, to run logistic regression.
E.g., \code{iv_1_ordered_levels = c("control", "treatment")}}

\item{iv_2_ordered_levels}{(only if the second independent variable
is a binary variable) a vector with the ordered levels of the first
independent variable, the first and second elements of which will be
coded as 0 and 1, respectively, to run logistic regression.
E.g., \code{iv_2_ordered_levels = c("male", "female")}}

\item{one_line_summary_only}{logical. Should the output simply be a
printout of a one-line summary on the interaction term? (default = FALSE)}

\item{p_value_interaction_only}{logical. Should the output simply be a
p-value of the interaction term in the logistic regression model?
(default = FALSE)}

\item{return_dt_w_binary}{logical. If \code{return_dt_w_binary = TRUE},
the function will return a data.table with binary variables coded
as 0 or 1 (default = FALSE)}
}
\value{
the output will be a summary of logistic regression results,
unless set otherwise by arguments to the function.
}
\description{
Conduct logistic regression for a model with an interaction between
two predictor variables
}
\examples{
logistic_reg_w_interaction(data = mtcars, dv_name = "vs",
iv_1_name = "mpg", iv_2_name = "am")
}
