% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/service.general.R
\name{service.check_obligatory_params}
\alias{service.check_obligatory_params}
\title{Check whether all obligatory paramenters of a given function are present.}
\usage{
service.check_obligatory_params(fx_params, args,
  predefined_result = TRUE)
}
\arguments{
\item{fx_params}{List. List of parameters required by function.}

\item{args}{List. Arguments transferred to the function upon user call.}

\item{predefined_result}{Logical. Required only in case if other checks were performed in the main script and the result of this check has to be processed to the function.
For example, if in the parent script I've checked the presence of height parameter, and it is absent (while is obligatory), I transfer this info in the "predefined_result = FALSE", so in the function the fx_params_resulting become False and will lead to stop().}
}
\value{
Character string. Returns a messages and stops function if any of the obligatory parameters are absent.
}
\description{
Check whether all obligatory paramenters of a given function are present.
}
\details{
Check whether all obligatory paramenters of a given function are present. 

Programming: Boris Bikbov \email{boris@bikbov.ru}.
}
\examples{
# could be run only inside function wich receives some parameters 
# fx_params <- c("creatinine", "age", "ethnicity", "sex")
# args <- names(as.list(match.call())[-1])
# service.check_obligatory_params(fx_params, args)
}
