% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_colour_tol.R
\name{scale_tol_sequential}
\alias{scale_tol_sequential}
\alias{scale_colour_YlOrBr}
\alias{scale_color_YlOrBr}
\alias{scale_fill_YlOrBr}
\alias{scale_colour_iridescent}
\alias{scale_color_iridescent}
\alias{scale_fill_iridescent}
\alias{scale_colour_discreterainbow}
\alias{scale_color_discreterainbow}
\alias{scale_fill_discreterainbow}
\alias{scale_colour_smoothrainbow}
\alias{scale_color_smoothrainbow}
\alias{scale_fill_smoothrainbow}
\title{Paul Tol's Sequential Color Schemes for \pkg{ggplot2}}
\usage{
scale_colour_YlOrBr(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  discrete = FALSE,
  aesthetics = "colour"
)

scale_color_YlOrBr(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  discrete = FALSE,
  aesthetics = "colour"
)

scale_fill_YlOrBr(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  discrete = FALSE,
  aesthetics = "fill"
)

scale_colour_iridescent(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  discrete = FALSE,
  aesthetics = "colour"
)

scale_color_iridescent(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  discrete = FALSE,
  aesthetics = "colour"
)

scale_fill_iridescent(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  discrete = FALSE,
  aesthetics = "fill"
)

scale_colour_discreterainbow(..., reverse = FALSE, aesthetics = "colour")

scale_color_discreterainbow(..., reverse = FALSE, aesthetics = "colour")

scale_fill_discreterainbow(..., reverse = FALSE, aesthetics = "fill")

scale_colour_smoothrainbow(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  discrete = FALSE,
  aesthetics = "colour"
)

scale_color_smoothrainbow(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  discrete = FALSE,
  aesthetics = "colour"
)

scale_fill_smoothrainbow(
  ...,
  reverse = FALSE,
  range = c(0, 1),
  discrete = FALSE,
  aesthetics = "fill"
)
}
\arguments{
\item{...}{Arguments passed to \code{\link[ggplot2:continuous_scale]{ggplot2::continuous_scale()}}.}

\item{reverse}{A \code{\link{logical}} scalar. Should the resulting
vector of colors be reversed?}

\item{range}{A length-two \code{\link{numeric}} vector specifying the
fraction of the scheme's color domain to keep.}

\item{discrete}{A \code{\link{logical}} scalar: should the color scheme be
used as a discrete scale? If \code{TRUE}, it is a departure from Paul Tol's
recommendations and likely a very poor use of color.}

\item{aesthetics}{A \code{\link{character}} string or vector of character
strings listing the name(s) of the aesthetic(s) that this scale works with.}
}
\value{
A \link[ggplot2:continuous_scale]{continuous} scale.
}
\description{
Provides sequential color scales from Paul Tol's \emph{Colour Schemes}.
}
\details{
If more colors than defined are needed from a given scheme, the color
coordinates are linearly interpolated to provide a continuous version of the
scheme, with the exception of the \verb{discrete rainbow} scheme (see below).

Note that the default color for \code{NA} can be overridden by passing
a value to \code{\link[ggplot2:continuous_scale]{ggplot2::continuous_scale()}}.

\tabular{lll}{
\strong{Palette} \tab \strong{Max. colors} \tab \strong{NA value} \cr
\code{YlOrBr} \tab 9 \tab #888888 \cr
\code{iridescent} \tab 23 \tab #999999 \cr
\verb{discrete rainbow} \tab 23 \tab #777777 \cr
\verb{smooth rainbow} \tab 34 \tab #666666 \cr
}
}
\section{Rainbow color scheme}{

As a general rule, ordered data should not be represented using a rainbow
scheme. There are three main arguments against such use (Tol 2018):
\itemize{
\item{The spectral order of visible light carries no inherent magnitude
message.}
\item{Some bands of almost constant hue with sharp transitions between
them, can be perceived as jumps in the data.}
\item{Colour-blind people have difficulty distinguishing some colours of
the rainbow.}
}
If such use cannot be avoided, Paul Tol's technical note provides two colour
schemes that are reasonably clear in colour-blind vision. To remain
colour-blind safe, these two schemes must comply with the following
conditions:
\describe{
\item{discrete rainbow}{This scheme must not be interpolated.}
\item{smooth rainbow}{This scheme does not have to be used over the full
range.}
}
}

\examples{
data(faithfuld, package = "ggplot2")

ggplot2::ggplot(faithfuld, ggplot2::aes(waiting, eruptions, fill = density)) +
  ggplot2::geom_raster() +
  scale_fill_YlOrBr()

ggplot2::ggplot(faithfuld, ggplot2::aes(waiting, eruptions, fill = density)) +
  ggplot2::geom_raster() +
  scale_fill_iridescent(reverse = TRUE)

ggplot2::ggplot(faithfuld, ggplot2::aes(waiting, eruptions, fill = density)) +
  ggplot2::geom_raster() +
  scale_fill_smoothrainbow(range = c(0.25, 1))
}
\references{
Tol, P. (2018). \emph{Colour Schemes}. SRON. Technical Note No.
SRON/EPS/TN/09-002, issue 3.1.
URL: \url{https://personal.sron.nl/~pault/data/colourschemes.pdf}
}
\seealso{
Other colour-blind safe colour schemes: 
\code{\link{scale_crameri_cyclic}},
\code{\link{scale_crameri_diverging}},
\code{\link{scale_crameri_mutlisequential}},
\code{\link{scale_crameri_sequential}},
\code{\link{scale_okabeito_discrete}},
\code{\link{scale_tol_discrete}},
\code{\link{scale_tol_diverging}}

Other sequential colour schemes: 
\code{\link{scale_crameri_sequential}}

Other Paul Tol's colour schemes: 
\code{\link{scale_tol_discrete}},
\code{\link{scale_tol_diverging}}
}
\author{
N. Frerebeau
}
\concept{Paul Tol's colour schemes}
\concept{colour-blind safe colour schemes}
\concept{sequential colour schemes}
