% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot2-tol.R
\name{scale_tol_diverging}
\alias{scale_tol_diverging}
\alias{scale_colour_sunset}
\alias{scale_color_sunset}
\alias{scale_fill_sunset}
\alias{scale_colour_BuRd}
\alias{scale_color_BuRd}
\alias{scale_fill_BuRd}
\alias{scale_colour_PRGn}
\alias{scale_color_PRGn}
\alias{scale_fill_PRGn}
\title{Paul Tol's diverging colour schemes for ggplot2}
\usage{
scale_colour_sunset(..., reverse = FALSE, aesthetics = "colour")

scale_color_sunset(..., reverse = FALSE, aesthetics = "colour")

scale_fill_sunset(..., reverse = FALSE, aesthetics = "fill")

scale_colour_BuRd(..., reverse = FALSE, aesthetics = "colour")

scale_color_BuRd(..., reverse = FALSE, aesthetics = "colour")

scale_fill_BuRd(..., reverse = FALSE, aesthetics = "fill")

scale_colour_PRGn(..., reverse = FALSE, aesthetics = "colour")

scale_color_PRGn(..., reverse = FALSE, aesthetics = "colour")

scale_fill_PRGn(..., reverse = FALSE, aesthetics = "fill")
}
\arguments{
\item{...}{Arguments passed to \code{\link[ggplot2]{continuous_scale}}.}

\item{reverse}{A \code{\link{logical}} scalar. Should the resulting
vector of colours be reversed?}

\item{aesthetics}{A \code{\link{character}} string or vector of character
strings listing the name(s) of the aesthetic(s) that this scale works with.}
}
\description{
Provides diverging colour scales from Paul Tol's \emph{Colour Schemes}.
}
\details{
Diverging colour schemes are linearly interpolated.
 \tabular{ll}{
  \strong{Palette} \tab \strong{Max.} \cr
  sunset \tab 11 \cr
  BuRd \tab 9 \cr
  PRGn \tab 9
 }
}
\examples{
library("ggplot2")

# Diverging data
ggplot(economics, aes(psavert, pce, colour = unemploy)) +
  geom_point() +
  scale_color_sunset()

ggplot(economics, aes(psavert, pce, colour = unemploy)) +
  geom_point() +
  scale_color_BuRd()

ggplot(economics, aes(psavert, pce, colour = unemploy)) +
  geom_point() +
  scale_color_PRGn()
}
\references{
Tol, Paul (2018). \emph{Colour Schemes.} SRON. Technical Note No.
 SRON/EPS/TN/09-002. URL: \url{https://personal.sron.nl/~pault/data/colourschemes.pdf}
}
\seealso{
Other Paul Tol's colour schemes: \code{\link{scale_tol_discrete}},
  \code{\link{scale_tol_sequential}}
}
\author{
N. Frerebeau
}
\concept{Paul Tol's colour schemes}
