% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{summary.kernelshap}
\alias{summary.kernelshap}
\title{Summarizes "kernelshap" Object}
\usage{
\method{summary}{kernelshap}(object, compact = FALSE, n = 2L, ...)
}
\arguments{
\item{object}{An object of class "kernelshap".}

\item{compact}{Set to \code{TRUE} for a more compact summary.}

\item{n}{Maximum number of rows of SHAP values etc. to print.}

\item{...}{Further arguments passed from other methods.}
}
\value{
Invisibly, the input is returned.
}
\description{
Summarizes "kernelshap" Object
}
\examples{
fit <- lm(Sepal.Length ~ ., data = iris)
s <- kernelshap(fit, iris[1:3, -1], bg_X = iris[, -1])
summary(s)
}
\seealso{
\code{\link[=kernelshap]{kernelshap()}}
}
