% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HyperResNet_HyperXception.R
\name{HyperResNet}
\alias{HyperResNet}
\title{HyperResNet}
\usage{
HyperResNet(
  include_top = TRUE,
  input_shape = NULL,
  input_tensor = NULL,
  classes = NULL
)
}
\arguments{
\item{include_top}{whether to include the fully-connected layer at the top of the network.}

\item{input_shape}{Optional shape list, e.g. `(256, 256, 3)`. One of `input_shape` or `input_tensor` must be specified.}

\item{input_tensor}{Optional Keras tensor (i.e. output of `layers.Input()`) to use as image input for the model. One of `input_shape` or `input_tensor` must be specified.}

\item{classes}{optional number of classes to classify images into, only to be specified if `include_top` is TRUE, and if no `weights` argument is specified. **kwargs: Additional keyword arguments that apply to all HyperModels. See `kerastuner.HyperModel`.}
}
\value{
a pre-trained ResNet model
}
\description{
A ResNet HyperModel.
}
\details{
# Arguments: include_top: whether to include the fully-connected layer at the top of the network. input_shape: Optional shape list, e.g. `(256, 256, 3)`. One of `input_shape` or `input_tensor` must be specified. input_tensor: Optional Keras tensor (i.e. output of `layers.Input()`) to use as image input for the model. One of `input_shape` or `input_tensor` must be specified. classes: optional number of classes to classify images into, only to be specified if `include_top` is TRUE, and if no `weights` argument is specified. **kwargs: Additional keyword arguments that apply to all HyperModels. See `kerastuner.HyperModel`.
}
\examples{

\donttest{
library(keras)
library(dplyr)
library(kerastuneR)

kerastuneR::install_kerastuner()

cifar <- dataset_cifar10()

hypermodel = kerastuneR::HyperResNet(input_shape = list(32L, 32L, 3L), classes = 10L)
hypermodel2 = kerastuneR::HyperXception(input_shape = list(32L, 32L, 3L), classes = 10L)


tuner = kerastuneR::Hyperband(
  hypermodel = hypermodel,
  objective = 'accuracy',
  loss = 'sparse_categorical_crossentropy',
  max_epochs = 1,
  directory = 'my_dir',
  project_name='helloworld')


train_data = cifar$train$x[1:30,1:32,1:32,1:3]
test_data = cifar$train$y[1:30,1] \%>\% as.matrix()


tuner \%>\% fit_tuner(train_data,test_data, epochs = 1)
}
}
