% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/activations.R
\name{activation_threshold}
\alias{activation_threshold}
\title{Threshold activation function.}
\usage{
activation_threshold(x, threshold, default_value)
}
\arguments{
\item{x}{Input tensor.}

\item{threshold}{The value that decides when to retain or replace x.}

\item{default_value}{Value to assign when \code{x <= threshold}.}
}
\value{
A tensor, the result from applying the activation to the input tensor \code{x}.
}
\description{
It is defined as:

\code{threshold(x) = x} if \code{x > threshold},
\code{threshold(x) = default_value} otherwise.
}
\seealso{
Other activations: \cr
\code{\link{activation_celu}()} \cr
\code{\link{activation_elu}()} \cr
\code{\link{activation_exponential}()} \cr
\code{\link{activation_gelu}()} \cr
\code{\link{activation_glu}()} \cr
\code{\link{activation_hard_shrink}()} \cr
\code{\link{activation_hard_sigmoid}()} \cr
\code{\link{activation_hard_tanh}()} \cr
\code{\link{activation_leaky_relu}()} \cr
\code{\link{activation_linear}()} \cr
\code{\link{activation_log_sigmoid}()} \cr
\code{\link{activation_log_softmax}()} \cr
\code{\link{activation_mish}()} \cr
\code{\link{activation_relu}()} \cr
\code{\link{activation_relu6}()} \cr
\code{\link{activation_selu}()} \cr
\code{\link{activation_sigmoid}()} \cr
\code{\link{activation_silu}()} \cr
\code{\link{activation_soft_shrink}()} \cr
\code{\link{activation_softmax}()} \cr
\code{\link{activation_softplus}()} \cr
\code{\link{activation_softsign}()} \cr
\code{\link{activation_sparse_plus}()} \cr
\code{\link{activation_sparsemax}()} \cr
\code{\link{activation_squareplus}()} \cr
\code{\link{activation_tanh}()} \cr
\code{\link{activation_tanh_shrink}()} \cr
}
\concept{activations}
