% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applications.R
\name{application_nasnet_large}
\alias{application_nasnet_large}
\title{Instantiates a NASNet model in ImageNet mode.}
\usage{
application_nasnet_large(
  input_shape = NULL,
  include_top = TRUE,
  weights = "imagenet",
  input_tensor = NULL,
  pooling = NULL,
  classes = 1000L,
  classifier_activation = "softmax",
  name = "nasnet_large"
)
}
\arguments{
\item{input_shape}{Optional shape tuple, only to be specified
if \code{include_top} is \code{FALSE} (otherwise the input shape
has to be \verb{(331, 331, 3)} for NASNetLarge.
It should have exactly 3 inputs channels,
and width and height should be no smaller than 32.
E.g. \verb{(224, 224, 3)} would be one valid value.}

\item{include_top}{Whether to include the fully-connected
layer at the top of the network.}

\item{weights}{\code{NULL} (random initialization) or
\code{imagenet} (ImageNet weights).  For loading \code{imagenet} weights,
\code{input_shape} should be (331, 331, 3)}

\item{input_tensor}{Optional Keras tensor (i.e. output of
\code{keras_input()})
to use as image input for the model.}

\item{pooling}{Optional pooling mode for feature extraction
when \code{include_top} is \code{FALSE}.
\itemize{
\item \code{NULL} means that the output of the model
will be the 4D tensor output of the
last convolutional layer.
\item \code{avg} means that global average pooling
will be applied to the output of the
last convolutional layer, and thus
the output of the model will be a
2D tensor.
\item \code{max} means that global max pooling will
be applied.
}}

\item{classes}{Optional number of classes to classify images
into, only to be specified if \code{include_top} is \code{TRUE}, and
if no \code{weights} argument is specified.}

\item{classifier_activation}{A \code{str} or callable. The activation function to
use on the "top" layer. Ignored unless \code{include_top=TRUE}. Set
\code{classifier_activation=NULL} to return the logits of the "top"
layer.  When loading pretrained weights, \code{classifier_activation}
can only be \code{NULL} or \code{"softmax"}.}

\item{name}{The name of the model (string).}
}
\value{
A Keras model instance.
}
\description{
Instantiates a NASNet model in ImageNet mode.
}
\section{Reference}{
\itemize{
\item \href{https://arxiv.org/abs/1707.07012}{Learning Transferable Architectures for Scalable Image Recognition} (CVPR 2018)
}

Optionally loads weights pre-trained on ImageNet.
Note that the data format convention used by the model is
the one specified in your Keras config at \verb{~/.keras/keras.json}.
}

\section{Note}{
Each Keras Application expects a specific kind of input preprocessing.
For NASNet, call \code{\link[=application_preprocess_inputs]{application_preprocess_inputs()}} on your
inputs before passing them to the model.
}

\seealso{
\itemize{
\item \url{https://keras.io/api/applications/nasnet#nasnetlarge-function}
}
}
