% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-rnn.R
\name{rnn_cell_simple}
\alias{rnn_cell_simple}
\title{Cell class for SimpleRNN.}
\usage{
rnn_cell_simple(
  units,
  activation = "tanh",
  use_bias = TRUE,
  kernel_initializer = "glorot_uniform",
  recurrent_initializer = "orthogonal",
  bias_initializer = "zeros",
  kernel_regularizer = NULL,
  recurrent_regularizer = NULL,
  bias_regularizer = NULL,
  kernel_constraint = NULL,
  recurrent_constraint = NULL,
  bias_constraint = NULL,
  dropout = 0,
  recurrent_dropout = 0,
  seed = NULL,
  ...
)
}
\arguments{
\item{units}{Positive integer, dimensionality of the output space.}

\item{activation}{Activation function to use.
Default: hyperbolic tangent (\code{tanh}).
If you pass \code{NULL}, no activation is applied
(ie. "linear" activation: \code{a(x) = x}).}

\item{use_bias}{Boolean, (default \code{TRUE}), whether the layer
should use a bias vector.}

\item{kernel_initializer}{Initializer for the \code{kernel} weights matrix,
used for the linear transformation of the inputs. Default:
\code{"glorot_uniform"}.}

\item{recurrent_initializer}{Initializer for the \code{recurrent_kernel}
weights matrix, used for the linear transformation
of the recurrent state. Default: \code{"orthogonal"}.}

\item{bias_initializer}{Initializer for the bias vector. Default: \code{"zeros"}.}

\item{kernel_regularizer}{Regularizer function applied to the \code{kernel} weights
matrix. Default: \code{NULL}.}

\item{recurrent_regularizer}{Regularizer function applied to the
\code{recurrent_kernel} weights matrix. Default: \code{NULL}.}

\item{bias_regularizer}{Regularizer function applied to the bias vector.
Default: \code{NULL}.}

\item{kernel_constraint}{Constraint function applied to the \code{kernel} weights
matrix. Default: \code{NULL}.}

\item{recurrent_constraint}{Constraint function applied to the
\code{recurrent_kernel} weights matrix. Default: \code{NULL}.}

\item{bias_constraint}{Constraint function applied to the bias vector.
Default: \code{NULL}.}

\item{dropout}{Float between 0 and 1. Fraction of the units to drop for the
linear transformation of the inputs. Default: 0.}

\item{recurrent_dropout}{Float between 0 and 1. Fraction of the units to drop
for the linear transformation of the recurrent state. Default: 0.}

\item{seed}{Random seed for dropout.}

\item{...}{For forward/backward compatability.}
}
\value{
A \code{Layer} instance, which is intended to be used with \code{layer_rnn()}.
}
\description{
This class processes one step within the whole time sequence input, whereas
\code{\link[=layer_simple_rnn]{layer_simple_rnn()}} processes the whole sequence.
}
\section{Call Arguments}{
\itemize{
\item \code{sequence}: A 2D tensor, with shape \verb{(batch, features)}.
\item \code{states}: A 2D tensor with shape \verb{(batch, units)}, which is the state
from the previous time step.
\item \code{training}: Python boolean indicating whether the layer should behave in
training mode or in inference mode. Only relevant when \code{dropout} or
\code{recurrent_dropout} is used.
}
}

\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{inputs <- random_uniform(c(32, 10, 8))
rnn <- layer_rnn(cell = rnn_cell_simple(units = 4))
output <- rnn(inputs)  # The output has shape `(32, 4)`.
rnn <- layer_rnn(
    cell = rnn_cell_simple(units = 4),
    return_sequences=TRUE,
    return_state=TRUE
)
# whole_sequence_output has shape `(32, 10, 4)`.
# final_state has shape `(32, 4)`.
c(whole_sequence_output, final_state) \%<-\% rnn(inputs)
}\if{html}{\out{</div>}}
}

\seealso{
Other rnn cells: \cr
\code{\link{layer_rnn}()} \cr
\code{\link{rnn_cell_gru}()} \cr
\code{\link{rnn_cell_lstm}()} \cr

Other simple rnn layers: \cr
\code{\link{layer_simple_rnn}()} \cr

Other rnn layers: \cr
\code{\link{layer_bidirectional}()} \cr
\code{\link{layer_conv_lstm_1d}()} \cr
\code{\link{layer_conv_lstm_2d}()} \cr
\code{\link{layer_conv_lstm_3d}()} \cr
\code{\link{layer_gru}()} \cr
\code{\link{layer_lstm}()} \cr
\code{\link{layer_rnn}()} \cr
\code{\link{layer_simple_rnn}()} \cr
\code{\link{layer_time_distributed}()} \cr
\code{\link{rnn_cell_gru}()} \cr
\code{\link{rnn_cell_lstm}()} \cr
\code{\link{rnn_cells_stack}()} \cr

Other layers: \cr
\code{\link{Layer}()} \cr
\code{\link{layer_activation}()} \cr
\code{\link{layer_activation_elu}()} \cr
\code{\link{layer_activation_leaky_relu}()} \cr
\code{\link{layer_activation_parametric_relu}()} \cr
\code{\link{layer_activation_relu}()} \cr
\code{\link{layer_activation_softmax}()} \cr
\code{\link{layer_activity_regularization}()} \cr
\code{\link{layer_add}()} \cr
\code{\link{layer_additive_attention}()} \cr
\code{\link{layer_alpha_dropout}()} \cr
\code{\link{layer_attention}()} \cr
\code{\link{layer_average}()} \cr
\code{\link{layer_average_pooling_1d}()} \cr
\code{\link{layer_average_pooling_2d}()} \cr
\code{\link{layer_average_pooling_3d}()} \cr
\code{\link{layer_batch_normalization}()} \cr
\code{\link{layer_bidirectional}()} \cr
\code{\link{layer_category_encoding}()} \cr
\code{\link{layer_center_crop}()} \cr
\code{\link{layer_concatenate}()} \cr
\code{\link{layer_conv_1d}()} \cr
\code{\link{layer_conv_1d_transpose}()} \cr
\code{\link{layer_conv_2d}()} \cr
\code{\link{layer_conv_2d_transpose}()} \cr
\code{\link{layer_conv_3d}()} \cr
\code{\link{layer_conv_3d_transpose}()} \cr
\code{\link{layer_conv_lstm_1d}()} \cr
\code{\link{layer_conv_lstm_2d}()} \cr
\code{\link{layer_conv_lstm_3d}()} \cr
\code{\link{layer_cropping_1d}()} \cr
\code{\link{layer_cropping_2d}()} \cr
\code{\link{layer_cropping_3d}()} \cr
\code{\link{layer_dense}()} \cr
\code{\link{layer_depthwise_conv_1d}()} \cr
\code{\link{layer_depthwise_conv_2d}()} \cr
\code{\link{layer_discretization}()} \cr
\code{\link{layer_dot}()} \cr
\code{\link{layer_dropout}()} \cr
\code{\link{layer_einsum_dense}()} \cr
\code{\link{layer_embedding}()} \cr
\code{\link{layer_feature_space}()} \cr
\code{\link{layer_flatten}()} \cr
\code{\link{layer_gaussian_dropout}()} \cr
\code{\link{layer_gaussian_noise}()} \cr
\code{\link{layer_global_average_pooling_1d}()} \cr
\code{\link{layer_global_average_pooling_2d}()} \cr
\code{\link{layer_global_average_pooling_3d}()} \cr
\code{\link{layer_global_max_pooling_1d}()} \cr
\code{\link{layer_global_max_pooling_2d}()} \cr
\code{\link{layer_global_max_pooling_3d}()} \cr
\code{\link{layer_group_normalization}()} \cr
\code{\link{layer_group_query_attention}()} \cr
\code{\link{layer_gru}()} \cr
\code{\link{layer_hashed_crossing}()} \cr
\code{\link{layer_hashing}()} \cr
\code{\link{layer_identity}()} \cr
\code{\link{layer_integer_lookup}()} \cr
\code{\link{layer_lambda}()} \cr
\code{\link{layer_layer_normalization}()} \cr
\code{\link{layer_lstm}()} \cr
\code{\link{layer_masking}()} \cr
\code{\link{layer_max_pooling_1d}()} \cr
\code{\link{layer_max_pooling_2d}()} \cr
\code{\link{layer_max_pooling_3d}()} \cr
\code{\link{layer_maximum}()} \cr
\code{\link{layer_minimum}()} \cr
\code{\link{layer_multi_head_attention}()} \cr
\code{\link{layer_multiply}()} \cr
\code{\link{layer_normalization}()} \cr
\code{\link{layer_permute}()} \cr
\code{\link{layer_random_brightness}()} \cr
\code{\link{layer_random_contrast}()} \cr
\code{\link{layer_random_crop}()} \cr
\code{\link{layer_random_flip}()} \cr
\code{\link{layer_random_rotation}()} \cr
\code{\link{layer_random_translation}()} \cr
\code{\link{layer_random_zoom}()} \cr
\code{\link{layer_repeat_vector}()} \cr
\code{\link{layer_rescaling}()} \cr
\code{\link{layer_reshape}()} \cr
\code{\link{layer_resizing}()} \cr
\code{\link{layer_rnn}()} \cr
\code{\link{layer_separable_conv_1d}()} \cr
\code{\link{layer_separable_conv_2d}()} \cr
\code{\link{layer_simple_rnn}()} \cr
\code{\link{layer_spatial_dropout_1d}()} \cr
\code{\link{layer_spatial_dropout_2d}()} \cr
\code{\link{layer_spatial_dropout_3d}()} \cr
\code{\link{layer_spectral_normalization}()} \cr
\code{\link{layer_string_lookup}()} \cr
\code{\link{layer_subtract}()} \cr
\code{\link{layer_text_vectorization}()} \cr
\code{\link{layer_tfsm}()} \cr
\code{\link{layer_time_distributed}()} \cr
\code{\link{layer_torch_module_wrapper}()} \cr
\code{\link{layer_unit_normalization}()} \cr
\code{\link{layer_upsampling_1d}()} \cr
\code{\link{layer_upsampling_2d}()} \cr
\code{\link{layer_upsampling_3d}()} \cr
\code{\link{layer_zero_padding_1d}()} \cr
\code{\link{layer_zero_padding_2d}()} \cr
\code{\link{layer_zero_padding_3d}()} \cr
\code{\link{rnn_cell_gru}()} \cr
\code{\link{rnn_cell_lstm}()} \cr
\code{\link{rnn_cells_stack}()} \cr
}
\concept{layers}
\concept{rnn cells}
\concept{rnn layers}
\concept{simple rnn layers}
