% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-preprocessing.R
\name{layer_hashing}
\alias{layer_hashing}
\title{A preprocessing layer which hashes and bins categorical features.}
\usage{
layer_hashing(object, num_bins, mask_value = NULL, salt = NULL, ...)
}
\arguments{
\item{object}{What to compose the new \code{Layer} instance with. Typically a
Sequential model or a Tensor (e.g., as returned by \code{layer_input()}).
The return value depends on \code{object}. If \code{object} is:
\itemize{
\item missing or \code{NULL}, the \code{Layer} instance is returned.
\item a \code{Sequential} model, the model with an additional layer is returned.
\item a Tensor, the output tensor from \code{layer_instance(object)} is returned.
}}

\item{num_bins}{Number of hash bins. Note that this includes the \code{mask_value} bin,
so the effective number of bins is \code{(num_bins - 1)} if \code{mask_value} is
set.}

\item{mask_value}{A value that represents masked inputs, which are mapped to
index 0. Defaults to NULL, meaning no mask term will be added and the
hashing will start at index 0.}

\item{salt}{A single unsigned integer or NULL.
If passed, the hash function used will be SipHash64, with these values
used as an additional input (known as a "salt" in cryptography).
These should be non-zero. Defaults to \code{NULL} (in that
case, the FarmHash64 hash function is used). It also supports
list of 2 unsigned integer numbers, see reference paper for details.}

\item{...}{standard layer arguments.}
}
\description{
A preprocessing layer which hashes and bins categorical features.
}
\details{
This layer transforms single or multiple categorical inputs to hashed output.
It converts a sequence of int or string to a sequence of int. The stable hash
function uses \verb{tensorflow::ops::Fingerprint} to produce the same output
consistently across all platforms.

This layer uses \href{https://github.com/google/farmhash}{FarmHash64} by default,
which provides a consistent hashed output across different platforms and is
stable across invocations, regardless of device and context, by mixing the
input bits thoroughly.

If you want to obfuscate the hashed output, you can also pass a random \code{salt}
argument in the constructor. In that case, the layer will use the
\href{https://github.com/google/highwayhash}{SipHash64} hash function, with
the \code{salt} value serving as additional input to the hash function.

\strong{Example (FarmHash64)}\if{html}{\out{<div class="sourceCode r">}}\preformatted{layer <- layer_hashing(num_bins=3)
inp <- matrix(c('A', 'B', 'C', 'D', 'E'))
layer(inp)
# <tf.Tensor: shape=(5, 1), dtype=int64, numpy=
#   array([[1],
#          [0],
#          [1],
#          [1],
#          [2]])>
}\if{html}{\out{</div>}}

\strong{Example (FarmHash64) with a mask value}\if{html}{\out{<div class="sourceCode r">}}\preformatted{layer <- layer_hashing(num_bins=3, mask_value='')
inp <- matrix(c('A', 'B', 'C', 'D', 'E'))
layer(inp)
# <tf.Tensor: shape=(5, 1), dtype=int64, numpy=
#   array([[1],
#          [1],
#          [0],
#          [2],
#          [2]])>
}\if{html}{\out{</div>}}

\strong{Example (SipHash64)}\if{html}{\out{<div class="sourceCode r">}}\preformatted{layer <- layer_hashing(num_bins=3, salt=c(133, 137))
inp <- matrix(c('A', 'B', 'C', 'D', 'E'))
layer(inp)
# <tf.Tensor: shape=(5, 1), dtype=int64, numpy=
#   array([[1],
#          [2],
#          [1],
#          [0],
#          [2]])>
}\if{html}{\out{</div>}}

\strong{Example (Siphash64 with a single integer, same as \verb{salt=[133, 133]})}\if{html}{\out{<div class="sourceCode r">}}\preformatted{layer <- layer_hashing(num_bins=3, salt=133)
inp <- matrix(c('A', 'B', 'C', 'D', 'E'))
layer(inp)
# <tf.Tensor: shape=(5, 1), dtype=int64, numpy=
#   array([[0],
#          [0],
#          [2],
#          [1],
#          [0]])>
}\if{html}{\out{</div>}}
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/Hashing}
\item \url{https://keras.io/api/layers/preprocessing_layers/categorical/hashing/}
}

Other categorical features preprocessing layers: 
\code{\link{layer_category_encoding}()},
\code{\link{layer_integer_lookup}()},
\code{\link{layer_string_lookup}()}

Other preprocessing layers: 
\code{\link{layer_category_encoding}()},
\code{\link{layer_center_crop}()},
\code{\link{layer_discretization}()},
\code{\link{layer_integer_lookup}()},
\code{\link{layer_normalization}()},
\code{\link{layer_random_contrast}()},
\code{\link{layer_random_crop}()},
\code{\link{layer_random_flip}()},
\code{\link{layer_random_height}()},
\code{\link{layer_random_rotation}()},
\code{\link{layer_random_translation}()},
\code{\link{layer_random_width}()},
\code{\link{layer_random_zoom}()},
\code{\link{layer_rescaling}()},
\code{\link{layer_resizing}()},
\code{\link{layer_string_lookup}()},
\code{\link{layer_text_vectorization}()}
}
\concept{categorical features preprocessing layers}
\concept{preprocessing layers}
