% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metrics.R
\name{metric_sensitivity_at_specificity}
\alias{metric_sensitivity_at_specificity}
\title{Computes best sensitivity where specificity is >= specified value}
\usage{
metric_sensitivity_at_specificity(
  ...,
  specificity,
  num_thresholds = 200L,
  class_id = NULL,
  name = NULL,
  dtype = NULL
)
}
\arguments{
\item{...}{Passed on to the underlying metric. Used for forwards and backwards compatibility.}

\item{specificity}{A scalar value in range \verb{[0, 1]}.}

\item{num_thresholds}{(Optional) Defaults to 200. The number of thresholds to
use for matching the given specificity.}

\item{class_id}{(Optional) Integer class ID for which we want binary metrics.
This must be in the half-open interval \verb{[0, num_classes)}, where
\code{num_classes} is the last dimension of predictions.}

\item{name}{(Optional) string name of the metric instance.}

\item{dtype}{(Optional) data type of the metric result.}
}
\value{
A (subclassed) \code{Metric} instance that can be passed directly to
\code{compile(metrics = )}, or used as a standalone object. See \code{?Metric} for
example usage.
}
\description{
The sensitivity at a given specificity.
}
\details{
\code{Sensitivity} measures the proportion of actual positives that are correctly
identified as such \code{(tp / (tp + fn))}. \code{Specificity} measures the proportion of
actual negatives that are correctly identified as such \code{(tn / (tn + fp))}.

This metric creates four local variables, \code{true_positives}, \code{true_negatives},
\code{false_positives} and \code{false_negatives} that are used to compute the
sensitivity at the given specificity. The threshold for the given specificity
value is computed and used to evaluate the corresponding sensitivity.

If \code{sample_weight} is \code{NULL}, weights default to 1. Use \code{sample_weight} of 0
to mask values.

If \code{class_id} is specified, we calculate precision by considering only the
entries in the batch for which \code{class_id} is above the threshold predictions,
and computing the fraction of them for which \code{class_id} is indeed a correct
label.

For additional information about specificity and sensitivity, see \href{https://en.wikipedia.org/wiki/Sensitivity_and_specificity}{the following}.
}
\seealso{
Other metrics: 
\code{\link{custom_metric}()},
\code{\link{metric_accuracy}()},
\code{\link{metric_auc}()},
\code{\link{metric_binary_accuracy}()},
\code{\link{metric_binary_crossentropy}()},
\code{\link{metric_categorical_accuracy}()},
\code{\link{metric_categorical_crossentropy}()},
\code{\link{metric_categorical_hinge}()},
\code{\link{metric_cosine_similarity}()},
\code{\link{metric_false_negatives}()},
\code{\link{metric_false_positives}()},
\code{\link{metric_hinge}()},
\code{\link{metric_kullback_leibler_divergence}()},
\code{\link{metric_logcosh_error}()},
\code{\link{metric_mean_absolute_error}()},
\code{\link{metric_mean_absolute_percentage_error}()},
\code{\link{metric_mean_iou}()},
\code{\link{metric_mean_relative_error}()},
\code{\link{metric_mean_squared_error}()},
\code{\link{metric_mean_squared_logarithmic_error}()},
\code{\link{metric_mean_tensor}()},
\code{\link{metric_mean_wrapper}()},
\code{\link{metric_mean}()},
\code{\link{metric_poisson}()},
\code{\link{metric_precision_at_recall}()},
\code{\link{metric_precision}()},
\code{\link{metric_recall_at_precision}()},
\code{\link{metric_recall}()},
\code{\link{metric_root_mean_squared_error}()},
\code{\link{metric_sparse_categorical_accuracy}()},
\code{\link{metric_sparse_categorical_crossentropy}()},
\code{\link{metric_sparse_top_k_categorical_accuracy}()},
\code{\link{metric_specificity_at_sensitivity}()},
\code{\link{metric_squared_hinge}()},
\code{\link{metric_sum}()},
\code{\link{metric_top_k_categorical_accuracy}()},
\code{\link{metric_true_negatives}()},
\code{\link{metric_true_positives}()}
}
\concept{metrics}
