% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-preprocessing.R
\name{layer_random_contrast}
\alias{layer_random_contrast}
\title{Adjust the contrast of an image or images by a random factor}
\usage{
layer_random_contrast(object, factor, seed = NULL, ...)
}
\arguments{
\item{object}{What to call the new \code{Layer} instance with. Typically a keras
\code{Model}, another \code{Layer}, or a \code{tf.Tensor}/\code{KerasTensor}. If \code{object} is
missing, the \code{Layer} instance is returned, otherwise, \code{layer(object)} is
returned.}

\item{factor}{a positive float represented as fraction of value, or a list of
size 2 representing lower and upper bound. When represented as a single
float, lower = upper. The contrast factor will be randomly picked between
\verb{[1.0 - lower, 1.0 + upper]}.}

\item{seed}{Integer. Used to create a random seed.}

\item{...}{standard layer arguments.}
}
\description{
Adjust the contrast of an image or images by a random factor
}
\details{
Contrast is adjusted independently for each channel of each image during
training.

For each channel, this layer computes the mean of the image pixels in the
channel and then adjusts each component \code{x} of each pixel to
\code{(x - mean) * contrast_factor + mean}.

Input shape:
3D (unbatched) or 4D (batched) tensor with shape:
\verb{(..., height, width, channels)}, in \code{"channels_last"} format.

Output shape:
3D (unbatched) or 4D (batched) tensor with shape:
\verb{(..., height, width, channels)}, in \code{"channels_last"} format.
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/RandomContrast}
\item \url{https://keras.io/api/layers/preprocessing_layers/}
}

Other image augmentation layers: 
\code{\link{layer_random_crop}()},
\code{\link{layer_random_flip}()},
\code{\link{layer_random_height}()},
\code{\link{layer_random_rotation}()},
\code{\link{layer_random_translation}()},
\code{\link{layer_random_width}()},
\code{\link{layer_random_zoom}()}

Other preprocessing layers: 
\code{\link{layer_category_encoding}()},
\code{\link{layer_center_crop}()},
\code{\link{layer_discretization}()},
\code{\link{layer_hashing}()},
\code{\link{layer_integer_lookup}()},
\code{\link{layer_normalization}()},
\code{\link{layer_random_crop}()},
\code{\link{layer_random_flip}()},
\code{\link{layer_random_height}()},
\code{\link{layer_random_rotation}()},
\code{\link{layer_random_translation}()},
\code{\link{layer_random_width}()},
\code{\link{layer_random_zoom}()},
\code{\link{layer_rescaling}()},
\code{\link{layer_resizing}()},
\code{\link{layer_string_lookup}()},
\code{\link{layer_text_vectorization}()}
}
\concept{image augmentation layers}
\concept{preprocessing layers}
