% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{k_random_uniform_variable}
\alias{k_random_uniform_variable}
\title{Instantiates a variable with values drawn from a uniform distribution.}
\usage{
k_random_uniform_variable(shape, low, high, dtype = NULL, name = NULL,
  seed = NULL)
}
\arguments{
\item{shape}{Tuple of integers, shape of returned Keras variable.}

\item{low}{Float, lower boundary of the output interval.}

\item{high}{Float, upper boundary of the output interval.}

\item{dtype}{String, dtype of returned Keras variable.}

\item{name}{String, name of returned Keras variable.}

\item{seed}{Integer, random seed.}
}
\value{
A Keras variable, filled with drawn samples.
}
\description{
Instantiates a variable with values drawn from a uniform distribution.
}
\section{Keras Backend}{


This function is part of a set of Keras backend functions that enable
lower level access to the core operations of the backend tensor engine
(e.g. TensorFlow, CNTK, Theano, etc.).

You can see a list of all available backend functions here:
\url{https://keras.rstudio.com/articles/backend.html#backend-functions}.
}

