% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-pooling.R
\name{layer_global_average_pooling_2d}
\alias{layer_global_average_pooling_2d}
\title{Global average pooling operation for spatial data.}
\usage{
layer_global_average_pooling_2d(
  object,
  data_format = NULL,
  keepdims = FALSE,
  ...
)
}
\arguments{
\item{object}{What to compose the new \code{Layer} instance with. Typically a
Sequential model or a Tensor (e.g., as returned by \code{layer_input()}).
The return value depends on \code{object}. If \code{object} is:
\itemize{
\item missing or \code{NULL}, the \code{Layer} instance is returned.
\item a \code{Sequential} model, the model with an additional layer is returned.
\item a Tensor, the output tensor from \code{layer_instance(object)} is returned.
}}

\item{data_format}{A string, one of \code{channels_last} (default) or
\code{channels_first}. The ordering of the dimensions in the inputs.
\code{channels_last} corresponds to inputs with shape \verb{(batch, height, width, channels)} while \code{channels_first} corresponds to inputs with shape \verb{(batch, channels, height, width)}. It defaults to the \code{image_data_format} value
found in your Keras config file at \verb{~/.keras/keras.json}. If you never set
it, then it will be "channels_last".}

\item{keepdims}{A boolean, whether to keep the spatial dimensions or not. If
\code{keepdims} is \code{FALSE} (default), the rank of the tensor is reduced for
spatial dimensions. If \code{keepdims} is \code{TRUE}, the spatial dimensions are
retained with length 1. The behavior is the same as for \code{tf.reduce_mean} or
\code{np.mean}.}

\item{...}{standard layer arguments.}
}
\description{
Global average pooling operation for spatial data.
}
\section{Input shape}{

\itemize{
\item If \code{data_format='channels_last'}: 4D tensor with shape: \verb{(batch_size, rows, cols, channels)}
\item If \code{data_format='channels_first'}: 4D tensor with shape: \verb{(batch_size, channels, rows, cols)}
}
}

\section{Output shape}{
 2D tensor with shape: \verb{(batch_size, channels)}
}

\seealso{
Other pooling layers: 
\code{\link{layer_average_pooling_1d}()},
\code{\link{layer_average_pooling_2d}()},
\code{\link{layer_average_pooling_3d}()},
\code{\link{layer_global_average_pooling_1d}()},
\code{\link{layer_global_average_pooling_3d}()},
\code{\link{layer_global_max_pooling_1d}()},
\code{\link{layer_global_max_pooling_2d}()},
\code{\link{layer_global_max_pooling_3d}()},
\code{\link{layer_max_pooling_1d}()},
\code{\link{layer_max_pooling_2d}()},
\code{\link{layer_max_pooling_3d}()}
}
\concept{pooling layers}
