% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-merge.R
\name{layer_concatenate}
\alias{layer_concatenate}
\title{Layer that concatenates a list of inputs.}
\usage{
layer_concatenate(inputs, ..., axis = -1)
}
\arguments{
\item{inputs}{A input tensor, or list of input tensors. Can be missing.}

\item{...}{Unnamed args are treated as additional \code{inputs}. Named arguments are passed on as standard layer arguments.}

\item{axis}{Concatenation axis.}
}
\value{
A tensor, the concatenation of the inputs alongside axis \code{axis}. If
\code{inputs} is missing, a keras layer instance is returned.
}
\description{
It takes as input a list of tensors, all of the same shape expect for the
concatenation axis, and returns a single tensor, the concatenation of all
inputs.
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/concatenate}
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/Concatenate}
\item \url{https://keras.io/api/layers/merging_layers/concatenate}
}

Other merge layers: 
\code{\link{layer_average}()},
\code{\link{layer_dot}()},
\code{\link{layer_maximum}()},
\code{\link{layer_minimum}()},
\code{\link{layer_multiply}()},
\code{\link{layer_subtract}()}
}
\concept{merge layers}
