% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{train_on_batch}
\alias{train_on_batch}
\alias{test_on_batch}
\title{Single gradient update or model evaluation over one batch of samples.}
\usage{
train_on_batch(object, x, y, class_weight = NULL, sample_weight = NULL)

test_on_batch(object, x, y, sample_weight = NULL)
}
\arguments{
\item{object}{Keras model object}

\item{x}{input data, as an array or list of arrays (if the model has multiple
inputs).}

\item{y}{labels, as an array.}

\item{class_weight}{named list mapping classes to a weight value, used for
scaling the loss function (during training only).}

\item{sample_weight}{sample weights, as an array.}
}
\value{
Scalar training or test loss (if the model has no metrics) or list of scalars
(if the model computes other metrics). The property \code{model$metrics_names}
will give you the display labels for the scalar outputs.
}
\description{
Single gradient update or model evaluation over one batch of samples.
}
\seealso{
Other model functions: \code{\link{compile}},
  \code{\link{evaluate.keras.engine.training.Model}},
  \code{\link{evaluate_generator}},
  \code{\link{fit_generator}}, \code{\link{fit}},
  \code{\link{get_config}}, \code{\link{get_layer}},
  \code{\link{keras_model_sequential}},
  \code{\link{keras_model}}, \code{\link{multi_gpu_model}},
  \code{\link{pop_layer}},
  \code{\link{predict.keras.engine.training.Model}},
  \code{\link{predict_generator}},
  \code{\link{predict_on_batch}},
  \code{\link{predict_proba}},
  \code{\link{summary.keras.engine.training.Model}}
}
