% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{predict_generator}
\alias{predict_generator}
\title{Generates predictions for the input samples from a data generator.}
\usage{
predict_generator(object, generator, steps, max_queue_size = 10,
  verbose = 0)
}
\arguments{
\item{object}{Keras model object}

\item{generator}{Generator yielding batches of input samples.}

\item{steps}{Total number of steps (batches of samples) to yield from
\code{generator} before stopping.}

\item{max_queue_size}{Maximum size for the generator queue.}

\item{verbose}{verbosity mode, 0 or 1.}
}
\value{
Numpy array(s) of predictions.
}
\description{
The generator should return the same kind of data as accepted by
\code{predict_on_batch()}.
}
\section{Raises}{
 ValueError: In case the generator yields data in an invalid
format.
}

\seealso{
Other model functions: \code{\link{compile}},
  \code{\link{evaluate_generator}}, \code{\link{evaluate}},
  \code{\link{fit_generator}}, \code{\link{fit}},
  \code{\link{get_config}}, \code{\link{get_layer}},
  \code{\link{keras_model_sequential}},
  \code{\link{keras_model}}, \code{\link{pop_layer}},
  \code{\link{predict.keras.engine.training.Model}},
  \code{\link{predict_on_batch}},
  \code{\link{predict_proba}},
  \code{\link{summary.keras.engine.training.Model}},
  \code{\link{train_on_batch}}
}
