% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{keras_array}
\alias{keras_array}
\title{Keras array object}
\usage{
keras_array(x, dim = dim(x), dtype = NULL)
}
\arguments{
\item{x}{Object or list of objects to convert}

\item{dim}{Integer vector with array dimensions (defaults to dimensions of
\code{x})}

\item{dtype}{NumPy data type (e.g. float32, float64). If this is unspecified
then R doubles will be converted to the default floating point type for the
current Keras backend.}
}
\value{
NumPy array with the specified dimensions and type (or list of NumPy
arrays if a list was passed for \code{x}).
}
\description{
Convert an R vector, matrix, or array object to an array that has the optimal
in-memory layout and floating point data type for the current Keras backend.
}
\details{
Keras does frequent row-oriented access to arrays (for shuffling and drawing
batches) so the order of arrays created by this function is always
row-oriented ("C" as opposed to "Fortran" ordering, which is the default for
R arrays).

If the passed array is already a NumPy array with the desired \code{dtype} and "C"
order then it is returned unmodified (no additional copies are made).
}
