% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendall_correlation.R
\name{kendall_cor_test}
\alias{kendall_cor_test}
\title{Kendall Correlation Test}
\usage{
kendall_cor_test(x, y, alternative = c("two.sided", "greater", "less"))
}
\arguments{
\item{x}{a numeric vector.}

\item{y}{a numeric vector.}

\item{alternative}{a character string specifying the alternative hypothesis.
The possible values are \code{"two.sided"}, \code{"greater"}, and \code{"less"}.}
}
\value{
A list with the following components:
\item{statistic}{The Kendall correlation coefficient.}
\item{p_value}{The p-value of the test.}
\item{alternative}{A character string describing the alternative hypothesis.}
}
\description{
\code{kendall_cor_test()} calculates p-value for the the
Kendall correlation using the exact values when the number of observations
is less than 50. For larger samples, it uses an approximation as in base R.
}
\examples{
x <- c(1, 0, 2)
y <- c(5, 3, 4)
kendall_cor_test(x, y)

}
\references{
Knight, W. R. (1966). "A Computer Method for Calculating
Kendall's Tau with Ungrouped Data". Journal of the American Statistical
Association, 61(314), 436–439.

Abrevaya J. (1999). Computation of the Maximum Rank Correlation Estimator.
Economic Letters 62, 279-285.

Christensen D. (2005). Fast algorithms for the calculation of Kendall's Tau.
Journal of Computational Statistics 20, 51-62.

Emara (2024). Khufu: Object-Oriented Programming using C++
}
