% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bandwidths.R
\name{bw_bern}
\alias{bw_bern}
\title{Bandwidth selection for the Bernstein copula estimator}
\usage{
bw_bern(udata)
}
\arguments{
\item{udata}{data.}
}
\value{
optimal order of the Bernstein polynomials.
}
\description{
The optimal size of knots is chosen by a rule of thumb adapted from
Rose (2015).
}
\details{
The formula is
\deqn{max(1, round(n^(1/3) * exp(abs(rho)^(1/n)) * (abs(rho) + 0.1))),}
where \eqn{\rho} is the empirical Spearman's rho of the data.
}
