# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Evaluate the mirror reflection estimator
#' 
#' @param uev mx2 matrix of evaluation points
#' @param data nx2 matrix of copula data.
#' @param b bandwidth parameter.
#' 
#' @return Density estimate evaluated at uev.
#' 
#' @noRd
eval_mr <- function(uev, dat, b) {
    .Call(`_kdecopula_eval_mr`, uev, dat, b)
}

#' Evaluate the beta kernel estimator
#' 
#' @param uev mx2 matrix of evaluation points
#' @param data nx2 matrix of copula data.
#' @param b bandwidth parameter.
#' 
#' @return Density estimate evaluated at uev.
#' 
#' @noRd
eval_beta <- function(uev, dat, b) {
    .Call(`_kdecopula_eval_beta`, uev, dat, b)
}

#' Evaluate the transformation estimator 
#' 
#' @param uev mx2 matrix of evaluation points
#' @param data nx2 matrix of copula data.
#' @param B 2x2 bandwidth matrix; must be positive definite.
#' 
#' @return Density estimate evaluated at uev.
#' 
#' @noRd
eval_t <- function(uev, dat, B) {
    .Call(`_kdecopula_eval_t`, uev, dat, B)
}

#' Evaluate an h-function corresponding to a copula density estimate
#' 
#' @param uev mx2 matrix of evaluation points
#' @param cond_var either 1 or 2; the variable to condition on.
#' @param vals matrix of density estimate evaluated on a kxk grid.
#' @param grid the grid points (1-dim) on which vals has been computed.
#' 
#' @return H-function estimate evaluated at uev.
#' 
#' @noRd
eval_hfunc_2d <- function(uev, cond_var, vals, grid) {
    .Call(`_kdecopula_eval_hfunc_2d`, uev, cond_var, vals, grid)
}

#' Evaluate the inverse of an h-function corresponding to a copula density 
#' estimate
#' 
#' @param uev mx2 matrix of evaluation points
#' @param cond_var either 1 or 2; the variable to condition on.
#' @param vals matrix of density estimate evaluated on a kxk grid.
#' @param grid the grid points (1-dim) on which vals has been computed.
#' 
#' @return Inverse h-function estimate evaluated at uev.
#' 
#' @noRd
inv_hfunc <- function(uev, cond_var, vals, grid) {
    .Call(`_kdecopula_inv_hfunc`, uev, cond_var, vals, grid)
}

#' Evaluate the cdf corresponding to a copula density estimate
#' 
#' @param uev mx2 matrix of evaluation points
#' @param vals vector of density estimate evaluated on a grid.
#' @param grid the grid points (1-dim) on which vals has been computed.
#' @param helpgrid auxiliary grid; see body of pkdecop.
#' @param helpind auxiliary indicators; see body of pkdecop.
#' 
#' @return Copula cdf estimate evaluated at uev.
#' 
#' @noRd
eval_cdf <- function(uev, vals, grid, helpgrid, helpind) {
    .Call(`_kdecopula_eval_cdf`, uev, vals, grid, helpgrid, helpind)
}

#' Integrate a spline interpolant
#'
#' @param upr upper limit of integration (lower is 0).
#' @param vals vector of values to be interpolated and integrated.
#' @param grid vector of grid points on which vals has been computed.
#'
#' @return Integral of interpolation spline defined by (vals, grid).
#'
#' @noRd
NULL

#' Calculate coefficients for cubic splines
#' 
#' @param vals length 4 vector of function values.
#' @param grid length 4 vector of grid points.
#' @param a vector of polynomial coefficients.
#' 
#' @noRd
NULL

interp_2d <- function(x, vals, grid, tmpgrid, tmpvals) {
    .Call(`_kdecopula_interp_2d`, x, vals, grid, tmpgrid, tmpvals)
}

interp <- function(x, vals, grid, helpind) {
    .Call(`_kdecopula_interp`, x, vals, grid, helpind)
}

#' Gaussian kernel (univariate)
#' 
#' @param x vector of evaluation points.
#' @param b bandwidth parameter.
#' 
#' @noRd
kern_gauss_1d <- function(x, b) {
    .Call(`_kdecopula_kern_gauss_1d`, x, b)
}

#' Gaussian product kernel (bivariate)
#'
#' Computes \eqn{K(x/b, y/b) / b}.
#'
#' @param x vector of evaluation points.
#' @param y vector of evaluation points.
#' @param b bandwidth parameter.
#' @noRd
kern_gauss_2d <- function(x, y, b) {
    .Call(`_kdecopula_kern_gauss_2d`, x, y, b)
}

#' Renormalize a d-dimensional copula density
#'
#'
#' @param x concatenated vector of function values.
#' @param grid vector of (univariate) grid points.
#' @param times iterations of the renormalization procedure.
#' @param helpind the (d-1)-dimensional expanded sequence 0:(knots-1).
#'
#' @noRd
renorm <- function(x, grid, times, helpind) {
    .Call(`_kdecopula_renorm`, x, grid, times, helpind)
}

