% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{logLik.kdecopula}
\alias{logLik.kdecopula}
\title{Log-Likelihood of a \code{kdecopula} object}
\usage{
\method{logLik}{kdecopula}(object, ...)
}
\arguments{
\item{object}{an object of class \code{kdecopula}.}

\item{...}{not used.}
}
\value{
Returns an object of class \code{\link[stats:logLik]{logLik}} containing the log-
likelihood, number of observations and effective number of parameters ("df").
}
\description{
Log-Likelihood of a \code{kdecopula} object
}
\examples{
## load data and transform with empirical cdf
data(wdbc)
udat <- apply(wdbc[, -1], 2, function(x) rank(x) / (length(x) + 1))

## estimation of copula density of variables 5 and 6
fit <- kdecop(udat[, 5:6])

## compute fit statistics
logLik(fit)
AIC(fit)
BIC(fit)

}
\seealso{
\code{\link[stats:logLik]{logLik}},
\code{\link[stats:AIC]{AIC}},
\code{\link[stats:BIC]{BIC}}
}
\author{
Thomas Nagler
}
