% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_footnote.R
\name{add_footnote}
\alias{add_footnote}
\title{Add footnote}
\usage{
add_footnote(input, label = NULL, notation = "alphabet",
  threeparttable = FALSE, escape = TRUE)
}
\arguments{
\item{input}{The direct output of your \code{kable} function or your last
\code{kableExtra} function.}

\item{label}{A vector of footnotes you want to add. You don't need to add
notations in your notes.}

\item{notation}{You can select the format of your footnote notation from
\code{number}, \code{alphabet}, \code{symbol} and \code{none}.}

\item{threeparttable}{Boolean value indicating if a
\href{https://www.ctan.org/pkg/threeparttable}{threeparttable} scheme should
be used.}

\item{escape}{Logical value controlling if the label needs to be escaped.
Default is TRUE.}
}
\description{
Add footnote to your favorite kable output.
}
\examples{
x <- knitr::kable(head(mtcars), "html")
add_footnote(x, c("footnote 1", "footnote 2"), notation = "symbol")

}
