% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{coef.fitted_dlm}
\alias{coef.fitted_dlm}
\title{coef.fitted_dlm}
\usage{
\method{coef}{fitted_dlm}(
  object,
  t.eval = seq_len(object$t),
  lag = -1,
  pred.cred = 0.95,
  eval.pred = FALSE,
  eval.metric = FALSE,
  ...
)
}
\arguments{
\item{object}{fitted_dlm: The fitted model to be use for evaluation.}

\item{t.eval}{numeric: A vector of positive integers indicating the time index from which to extract predictions. The default is to extract to evaluate the model at all observed times.}

\item{lag}{integer: The relative offset for forecast. Values for time t will be calculated based on the filtered values of time t-h. If lag is negative, then the smoothed distribution for the latent states will be used.}

\item{pred.cred}{numeric: The credibility level for the C.I..}

\item{eval.pred}{boolean: A flag indicating if the predictions should be calculated.}

\item{eval.metric}{boolean: A flag indicating if the model density (f(M|y)) should be calculated. Only used when lag<0.}

\item{...}{Extra arguments passed to the coef method.}
}
\value{
A list containing:
\itemize{
   \item data data.frame: A table with the model evaluated at each observed time.
   \item theta.mean matrix: The mean of the latent states at each time. Dimensions are n x t, where t is the size of t.eval and n is the number of latent states.
   \item theta.cov array: A 3D-array containing the covariance matrix of the latent states at each time. Dimensions are n x n x t, where t is the size of t.eval and n is the number of latent states.
   \item lambda.mean matrix: The mean of the linear predictor at each time. Dimensions are k x t, where t is the size of t.eval and k is the number of linear predictors.
   \item lambda.cov array: A 3D-array containing the covariance matrix for the linear predictor at each time. Dimensions are k x k x t, where t is the size of t.eval and k is the number of linear predictors.
   \item log.like, mae, mase, rae, mse, interval.score: The metric value at each time.
   \item conj.param list: A list containing, for each outcome, a data.frame with the parameter of the conjugated distribution at each time.
}
}
\description{
Evaluates the predictive values for the observed values used to fit the model and its latent states.
Predictions can be made with smoothed values, with filtered values or h-steps ahead.
}
\examples{
# Poisson case
data <- c(AirPassengers)

level <- polynomial_block(rate = 1, order = 2, D = 0.95)
season <- harmonic_block(rate = 1, order = 2, period = 12, D = 0.975)

outcome <- Poisson(lambda = "rate", data = data)

fitted.data <- fit_model(level, season,
  AirPassengers = outcome
)

var.vals <- coef(fitted.data)

}
\seealso{
Other auxiliary functions for fitted_dlm objects: 
\code{\link{eval_dlm_norm_const}()},
\code{\link{fit_model}()},
\code{\link{forecast.fitted_dlm}()},
\code{\link{simulate.fitted_dlm}()},
\code{\link{smoothing}()},
\code{\link{update.fitted_dlm}()}
}
\concept{auxiliary functions for fitted_dlm objects}
