% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.r
\name{is_numeric_str}
\alias{is_numeric_str}
\alias{areNumeric}
\title{Which elements of a character vector are numeric}
\usage{
is_numeric_str(x, extras = c(".", "NA", NA))

areNumeric(x, extras = c(".", "NA", NA))
}
\arguments{
\item{x}{character vector}

\item{extras}{character vector containing acceptable alternatives to numeric
values which will result in returning \code{TRUE} for that element. Default
is \code{c(".", "NA", NA)}.}
}
\value{
logical vector of same length as input
}
\description{
Takes a character vector and returns a logical vector of the same length,
indicating which values are numeric. \code{NA} is considered non-numeric. \code{NA} is
never returned from this function.
}
\section{Functions}{
\itemize{
\item \code{areNumeric}: Deprecated
}}

\examples{
areNumeric(c("1", "2", "3"))
areNumeric(c("1L", "2.2"))
areNumeric(c("NA", NA, ".", "", "-1.9"))
}
