% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jjcsformats.R
\name{count and fraction related formatting functions}
\alias{count and fraction related formatting functions}
\alias{jjcsformat_cnt_den_fract_fct}
\alias{jjcsformat_count_fraction}
\alias{jjcsformat_count_denom_fraction}
\alias{jjcsformat_fraction_count_denom}
\title{Formatting functions for count and fraction, and for count denominator and fraction values}
\usage{
jjcsformat_cnt_den_fract_fct(
  d = 1,
  type = c("count_fraction", "count_denom_fraction", "fraction_count_denom"),
  verbose = FALSE
)

jjcsformat_count_fraction(x, round_type = valid_round_type, output, ...)

jjcsformat_count_denom_fraction(x, round_type = valid_round_type, output, ...)

jjcsformat_fraction_count_denom(x, round_type = valid_round_type, output, ...)
}
\arguments{
\item{d}{(\code{numeric(1)})\cr Number of digits to round fraction to (default = 1)}

\item{type}{(\verb{character(1})\cr One of \code{count_fraction}, \code{count_denom_fraction}, \code{fraction_count_denom},
to specify the type of format the function will represent.}

\item{verbose}{(\code{logical})\cr Whether to print verbose output}

\item{x}{(\verb{numeric vector})\cr Vector with elements \code{num} and \code{fraction} or \code{num}, \code{denom} and \code{fraction}.}

\item{round_type}{(\code{character(1)})\cr the type of rounding to perform.
See \code{\link[formatters:format_value]{formatters::format_value()}} for more details.}

\item{output}{(\code{string})\cr output type.
See \code{\link[formatters:format_value]{formatters::format_value()}} for more details.}

\item{...}{Additional arguments passed to other methods.}
}
\value{
A formatting function to format input into string in the format \verb{count / denom (ratio percent)}. If \code{count}
is 0, the format is \code{0}. If fraction is >0.99, the format is
\verb{count / denom (>99.9 percent)}
}
\description{
Formats a count together with fraction (and/or denominator) with special
consideration when count is 0, or fraction is 1.
\cr See also: \code{\link[tern:format_count_fraction_fixed_dp]{tern::format_count_fraction_fixed_dp()}}
}
\examples{

jjcsformat_count_fraction(c(7, 0.7))
jjcsformat_count_fraction(c(70000, 70000 / 70001))
jjcsformat_count_fraction(c(235, 235 / 235))
fmt <- jjcsformat_cnt_den_fract_fct(type = "count_fraction", d = 2)
fmt(c(23, 23 / 235))

jjcsformat_count_denom_fraction(c(7, 10, 0.7))
jjcsformat_count_denom_fraction(c(70000, 70001, 70000 / 70001))
jjcsformat_count_denom_fraction(c(235, 235, 235 / 235))
fmt <- jjcsformat_cnt_den_fract_fct(type = "count_denom_fraction", d = 2)
fmt(c(23, 235, 23 / 235))

jjcsformat_fraction_count_denom(c(7, 10, 0.7))
jjcsformat_fraction_count_denom(c(70000, 70001, 70000 / 70001))
jjcsformat_fraction_count_denom(c(235, 235, 235 / 235))
fmt <- jjcsformat_cnt_den_fract_fct(type = "fraction_count_denom", d = 2)
fmt(c(23, 235, 23 / 235))
}
\seealso{
Other JJCS formatting functions: 
\code{\link{jjcsformat_xx}()}
}
\concept{JJCS formatting functions}
