% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_summarize_ex_j.R
\name{a_summarize_ex_j}
\alias{a_summarize_ex_j}
\alias{s_summarize_ex_j}
\title{Tabulation for Exposure Tables}
\usage{
s_summarize_ex_j(
  df,
  .var,
  .df_row,
  .spl_context,
  comp_btw_group = TRUE,
  ref_path = NULL,
  ancova = FALSE,
  interaction_y,
  interaction_item,
  conf_level,
  daysconv,
  variables
)

a_summarize_ex_j(
  df,
  .var,
  .df_row,
  .spl_context,
  comp_btw_group = TRUE,
  ref_path = NULL,
  ancova = FALSE,
  interaction_y = FALSE,
  interaction_item = NULL,
  conf_level = 0.95,
  variables,
  .stats = c("mean_sd", "median", "range", "quantiles", "total_subject_years"),
  .formats = c(diff_mean_est_ci = jjcsformat_xx("xx.xx (xx.xx, xx.xx)")),
  .labels = c(quantiles = "Interquartile range"),
  .indent_mods = NULL,
  na_str = rep("NA", 3),
  daysconv = 1
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{.df_row}{(\code{data.frame})\cr data frame across all of the columns for the given row split.}

\item{.spl_context}{(\code{data.frame})\cr gives information about ancestor split states
that is passed by \code{rtables}.}

\item{comp_btw_group}{(\code{logical})\cr If TRUE,
\cr When ancova = FALSE, the estimate of between group difference (on CHG) will be based upon two-sample t-test. \cr
\cr When ancova = TRUE, the same ancova model will be used for the estimate of between group difference (on CHG).}

\item{ref_path}{(\code{character})\cr global reference group specification, see \code{\link[=get_ref_info]{get_ref_info()}}.}

\item{ancova}{(\code{logical})\cr If FALSE, only descriptive methods will be used. \cr
If TRUE Ancova methods will be used for each of the columns : AVAL, CHG, DIFF. \cr}

\item{interaction_y}{(\code{character})\cr Will be passed onto the \code{tern} function \code{s_ancova}, when ancova = TRUE.}

\item{interaction_item}{(\code{character})\cr Will be passed onto the \code{tern} function \code{s_ancova}, when ancova = TRUE.}

\item{conf_level}{(\code{proportion})\cr Confidence level of the interval}

\item{daysconv}{conversion required to get the values into days
(i.e 1 if original PARAMCD unit is days, 30.4375 if original PARAMCD unit is in months)}

\item{variables}{(named list of strings)\cr
list of additional analysis variables, with expected elements:
\itemize{
\item arm (string)\cr
group variable, for which the covariate adjusted means of multiple groups will be summarized.
Specifically, the first level of arm variable is taken as the reference group.
\item covariates (character)\cr
a vector that can contain single variable names (such as 'X1'), and/or interaction terms indicated by 'X1 * X2'.
}}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named \code{character} or \code{list})\cr formats for the statistics. See Details in \code{analyze_vars} for more
information on the \code{'auto'} setting.}

\item{.labels}{(named \code{character})\cr labels for the statistics (without indent).}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}

\item{na_str}{(\code{string})\cr string used to replace all \code{NA} or empty values in the output.}
}
\value{
\itemize{
\item \code{a_summarize_ex_j()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}
}
\description{
A function to create the appropriate statistics needed for exposure table
}
\details{
Creates statistics needed for standard exposure table
This includes differences and 95\% CI and total treatment years.
This is designed to be used as an analysis (afun in \code{analyze}) function.

Creates statistics needed for table. This includes differences and 95\% CI and total treatment years.
This is designed to be used as an analysis (afun in \code{analyze}) function.
}
\section{Functions}{
\itemize{
\item \code{s_summarize_ex_j()}: Statistics function needed for the exposure tables

\item \code{a_summarize_ex_j()}: Formatted analysis function which is used as \code{afun}.

}}
\examples{
library(dplyr)

ADEX <- data.frame(
  USUBJID = c(
    "XXXXX01", "XXXXX02", "XXXXX03", "XXXXX04", "XXXXX05",
    "XXXXX06", "XXXXX07", "XXXXX08", "XXXXX09", "XXXXX10"
  ),
  TRT01A = c(
    "ARMA", "ARMA", "ARMA", "ARMA", "ARMA",
    "Placebo", "Placebo", "Placebo", "ARMA", "ARMA"
  ),
  AVAL = c(56, 78, 67, 87, 88, 93, 39, 87, 65, 55)
)

ADEX <- ADEX |>
  mutate(TRT01A = as.factor(TRT01A))

ADEX$colspan_trt <- factor(ifelse(ADEX$TRT01A == "Placebo", " ", "Active Study Agent"),
  levels = c("Active Study Agent", " ")
)

ADEX$diff_header <- "Difference in Means (95\% CI)"
ADEX$diff_label <- paste(ADEX$TRT01A, paste("vs", "Placebo"))

colspan_trt_map <- create_colspan_map(ADEX,
  non_active_grp = "Placebo",
  non_active_grp_span_lbl = " ",
  active_grp_span_lbl = "Active Study Agent",
  colspan_var = "colspan_trt",
  trt_var = "TRT01A"
)
ref_path <- c("colspan_trt", "", "TRT01A", "Placebo")

lyt <- basic_table() |>
  split_cols_by(
    "colspan_trt",
    split_fun = trim_levels_to_map(map = colspan_trt_map)
  ) |>
  split_cols_by("TRT01A") |>
  split_cols_by("diff_header", nested = FALSE) |>
  split_cols_by(
    "TRT01A",
    split_fun = remove_split_levels("Placebo"),
    labels_var = "diff_label"
  ) |>
  analyze("AVAL",
    afun = a_summarize_ex_j, var_labels = "Duration of treatment (Days)",
    show_labels = "visible",
    indent_mod = 0L,
    extra_args = list(
      daysconv = 1,
      ref_path = ref_path,
      variables = list(arm = "TRT01A", covariates = NULL),
      ancova = TRUE,
      comp_btw_group = TRUE
    )
  )

result <- build_table(lyt, ADEX)

result
}
