% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_ancova.R
\name{a_summarize_ancova_j}
\alias{a_summarize_ancova_j}
\alias{s_summarize_ancova_j}
\title{ANCOVA Summary Function}
\usage{
a_summarize_ancova_j(
  df,
  .var,
  .df_row,
  ref_path,
  .spl_context,
  ...,
  .stats = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)

s_summarize_ancova_j(df, .var, .df_row, .ref_group, .in_ref_col, ...)
}
\arguments{
\item{df}{: need to check on how to inherit params from tern::s_ancova}

\item{.var}{(\code{string})\cr single variable name that is passed by \code{rtables} when requested
by a statistics function.}

\item{.df_row}{(\code{data.frame})\cr data set that includes all the variables that are called in \code{.var} and \code{variables}.}

\item{ref_path}{(\code{character})\cr path to the reference group.}

\item{.spl_context}{(\code{environment})\cr split context environment.}

\item{...}{Additional arguments passed to \code{s_ancova_j}.}

\item{.stats}{(\code{character})\cr statistics to calculate.}

\item{.formats}{(\code{list})\cr formats for the statistics.}

\item{.labels}{(\code{list})\cr labels for the statistics.}

\item{.indent_mods}{(\code{list})\cr indentation modifications for the statistics.}

\item{.ref_group}{(\code{data.frame} or \code{vector})\cr the data corresponding to the reference group.}

\item{.in_ref_col}{(\code{flag})\cr \code{TRUE} when working with the reference level, \code{FALSE} otherwise.}
}
\value{
\itemize{
\item \code{a_summarize_ancova_j()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}

returns the statistics from tern::s_summary(x), appended with a new statistics based upon ANCOVA
}
\description{
Combination of tern::s_summary, and ANCOVA based estimates for mean and diff between columns,
based on ANCOVA function \code{s_ancova_j}
}
\details{
Combination of tern::s_summary, and ANCOVA based estimates for mean and diff between columns,
based on ANCOVA function \code{s_ancova_j}
}
\section{Functions}{
\itemize{
\item \code{a_summarize_ancova_j()}: Formatted analysis function which is used as \code{afun}. Note that the
junco specific \code{ref_path} and \code{.spl_context} arguments are used for reference column information.

}}
\examples{

basic_table() |>
  split_cols_by("Species") |>
  add_colcounts() |>
  analyze(
    vars = "Petal.Length",
    afun = a_summarize_ancova_j,
    show_labels = "hidden",
    na_str = tern::default_na_str(),
    table_names = "unadj",
    var_labels = "Unadjusted comparison",
    extra_args = list(
      variables = list(arm = "Species", covariates = NULL),
      conf_level = 0.95,
      .labels = c(lsmean = "Mean", lsmean_diff = "Difference in Means"),
      ref_path = c("Species", "setosa")
    )
  ) |>
  analyze(
    vars = "Petal.Length",
    afun = a_summarize_ancova_j,
    show_labels = "hidden",
    na_str = tern::default_na_str(),
    table_names = "adj",
    var_labels = "Adjusted comparison (covariates: Sepal.Length and Sepal.Width)",
    extra_args = list(
      variables = list(
        arm = "Species",
        covariates = c("Sepal.Length", "Sepal.Width")
      ),
      conf_level = 0.95,
      ref_path = c("Species", "setosa")
    )
  ) |>
  build_table(iris)

library(dplyr)
library(tern)

df <- iris |> filter(Species == "virginica")
.df_row <- iris
.var <- "Petal.Length"
variables <- list(arm = "Species", covariates = "Sepal.Length * Sepal.Width")
.ref_group <- iris |> filter(Species == "setosa")
conf_level <- 0.95
s_summarize_ancova_j(
  df,
  .var = .var,
  .df_row = .df_row,
  variables = variables,
  .ref_group = .ref_group,
  .in_ref_col = FALSE,
  conf_level = conf_level
)
}
\seealso{
Other Inclusion of ANCOVA Functions: 
\code{\link{a_summarize_aval_chg_diff_j}()},
\code{\link{s_ancova_j}()}
}
\concept{Inclusion of ANCOVA Functions}
