% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/references.R
\name{jst_get_references}
\alias{jst_get_references}
\title{Extract all references}
\usage{
jst_get_references(file_path)
}
\arguments{
\item{file_path}{The path to the \code{.xml}-file from which references should be
extracted.}
}
\value{
A \code{tibble} with three two containing the references:
\itemize{
\item \code{basename_id}: the identifier for the article the references come from.
\item \code{references}: the text of the references.
}
}
\description{
This function extracts the content of \code{ref-list} from the \code{xml}-file.
}
\details{
This content may contain references or endnotes, depending on how the article
used citations. Since references are currently not fully supported by DfR,
there is no comprehensive documentation on the different variants. \code{jstor}
therefore extracts the content of \code{ref-list} exactly as it appears in the
data. Because of this, there might be other content present than references.

In order to get all available information on citation data, you might need to
combine \code{jst_get_references()} with \code{jst_get_footnotes()}.

For newer \code{xml}-files, there would be the option to extract single elements
like authors, title or date of the source, but this is not yet implemented.

In general, the implementation is not as fast as \code{jst_get_article()} -
articles with many references slow the process down.
}
\examples{
jst_get_references(jst_example("sample_with_references.xml"))
}
