% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cox2.R
\name{cox2.display}
\alias{cox2.display}
\title{cox2.display: table for coxph.object with model option: TRUE - allow "frailty" or "cluster" model}
\usage{
cox2.display(cox.obj.withmodel, dec = 2)
}
\arguments{
\item{cox.obj.withmodel}{coxph.object with model option: TRUE}

\item{dec}{Decimal point, Default: 2}
}
\value{
Table, cluster/frailty info, metrics, caption
}
\description{
Table for coxph.object with model option: TRUE - allow "frailty" or "cluster" model
}
\details{
GEE like - cluster, Mixed effect model like - frailty
}
\examples{
 library(survival);data(lung)
 fit1 <- coxph(Surv(time, status) ~ ph.ecog + age + cluster(inst), data = lung, model = TRUE)
 fit2 <- coxph(Surv(time, status) ~ ph.ecog + age + frailty(inst), data = lung, model = TRUE)
 cox2.display(fit1)
 cox2.display(fit2)
}
