% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_json.R
\name{parse_json}
\alias{parse_json}
\title{Convert JSON to an \R{} object}
\usage{
parse_json(
  x,
  .na = json_na_error(),
  .null = NULL,
  simplifyVector = TRUE,
  simplifyDataFrame = FALSE,
  simplifyMatrix = FALSE,
  flatten = FALSE,
  bigint_as_char = bigint_default(),
  ...
)
}
\arguments{
\item{x}{a scalar JSON character}

\item{.na}{Value to return if \code{x} is \code{NA}. By default an error of class
\code{jsontools_error_na_json} is thrown.}

\item{.null}{Return the prototype of \code{.null} if \code{x} is \code{NULL}
or a zero length character}

\item{simplifyVector, simplifyDataFrame, simplifyMatrix, flatten, ...}{passed on
to \code{\link[jsonlite:read_json]{jsonlite::parse_json}}.}

\item{bigint_as_char}{Parse big integers as character? The option
\code{jsontools.bigint_as_char} is used as default.}
}
\value{
A \R{} object. The type depends on the input but is usually a list or a
data frame.
}
\description{
A wrapper around the great \code{\link[jsonlite:read_json]{jsonlite::parse_json}}. The differences are:
\itemize{
\item expose argument \code{bigint_as_char} with default \code{TRUE}.
\item control how to handle \code{NA} and \code{NULL}.
\item \code{simplifyDataFrame}, \code{simplifyMatrix}, and \code{flatten} default to \code{FALSE} as
they are not very stable in many real world APIs. Use the
\href{https://cran.r-project.org/package=tibblify}{tibblify package}
for a more robust conversion to a dataframe.
\item don't collapse strings but error instead if they have more than one element.
}
}
\details{
To parse a vector of JSON use \code{\link{parse_json_vector}}.
}
\examples{
# Parse escaped unicode
parse_json('{"city" : "Z\\\\u00FCrich"}')

# big integers
big_num <- "9007199254740993"
as.character(parse_json(big_num, bigint_as_char = FALSE))
as.character(parse_json(big_num, bigint_as_char = TRUE))

# NA error by default
try(parse_json(NA))
# ... but one can specify a default value
parse_json(NA, .na = data.frame(a = 1, b = 2))

# input of size 0
parse_json(NULL)
parse_json(character(), .null = data.frame(a = 1, b = 2))
}
