% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FileRepeatedInput.R
\name{FileRepeatedInput}
\alias{FileRepeatedInput}
\title{FileRepeatedInput: UI for repeated measures analysis.}
\usage{
FileRepeatedInput(id, label = "Upload data (csv/xlsx/sav/sas7bdat/dta)")
}
\arguments{
\item{id}{A string, the module id.}

\item{label}{A string, the label for the file input.}
}
\value{
A Shiny UI object.
}
\description{
File upload UI for repeated measure analysis.
}
\examples{
if (interactive()) {
  library(shiny)
  library(DT)
  library(jstable)

  ui <- fluidPage(
    sidebarLayout(
      sidebarPanel(FileRepeatedInput("datafile")),
      mainPanel(
        tabsetPanel(
          type = "pills",
          tabPanel("Data", DTOutput("data")),
          tabPanel("Label", DTOutput("data_label"))
        )
      )
    )
  )

  server <- function(input, output, session) {
    data_info <- callModule(FileRepeated, "datafile")
    output$data <- renderDT({
      data_info()$data
    })
    output$label <- renderDT({
      data_info()$label
    })
  }
  shinyApp(ui, server)
}
}
