% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tb1.R
\name{tb1moduleUI}
\alias{tb1moduleUI}
\title{tb1moduleUI: table 1 module UI.}
\usage{
tb1moduleUI(id)
}
\arguments{
\item{id}{id}
}
\value{
Table 1 module UI.
}
\description{
Table 1 shiny module UI for descriptive statistics.
}
\details{
Table 1 shiny module UI for descriptive statistics.
}
\examples{
library(shiny)
library(DT)
library(data.table)
library(jstable)
ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      tb1moduleUI("tb1")
    ),
    mainPanel(
      DTOutput("table1")
    )
  )
)

server <- function(input, output, session) {
  data <- reactive(mtcars)
  data.label <- reactive(jstable::mk.lev(mtcars))

  out_tb1 <- callModule(tb1module2, "tb1",
    data = data, data_label = data.label,
    data_varStruct = NULL
  )

  output$table1 <- renderDT({
    tb <- out_tb1()$table
    cap <- out_tb1()$caption
    out.tb1 <- datatable(tb, rownames = T, extension = "Buttons", caption = cap)
    return(out.tb1)
  })
}
}
