% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gee.R
\name{GEEModuleLinear}
\alias{GEEModuleLinear}
\title{GEEModuleLinear: shiny modulde server for gaussian generalized estimating equation(GEE) using reactive data.}
\usage{
GEEModuleLinear(
  input,
  output,
  session,
  data,
  data_label,
  data_varStruct = NULL,
  nfactor.limit = 10,
  id.gee
)
}
\arguments{
\item{input}{input}

\item{output}{output}

\item{session}{session}

\item{data}{reactive data, ordered by id.}

\item{data_label}{reactive data label}

\item{data_varStruct}{List of variable structure, Default: NULL}

\item{nfactor.limit}{nlevels limit in factor variable, Default: 10}

\item{id.gee}{reactive repeated measure variable}
}
\value{
Shiny modulde server for gaussian generalized estimating equation(GEE).
}
\description{
Shiny modulde server for gaussian generalized estimating equation(GEE) using reactive data.
}
\details{
Shiny modulde server for gaussian generalized estimating equation(GEE) using reactive data.
}
\examples{
library(shiny)
library(DT)
library(data.table)
library(jstable)
ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      GEEModuleUI("linear")
    ),
    mainPanel(
      DTOutput("lineartable")
    )
  )
)

server <- function(input, output, session) {
  data <- reactive(mtcars)
  data.label <- reactive(jstable::mk.lev(mtcars))
  id.gee <- reactive("mpg")

  out_linear <- callModule(GEEModuleLinear, "linear",
    data = data, data_label = data.label,
    data_varStruct = NULL, id.gee = id.gee
  )

  output$lineartable <- renderDT({
    hide <- which(colnames(out_linear()$table) == "sig")
    datatable(out_linear()$table,
      rownames = T, extension = "Buttons", caption = out_linear()$caption,
      options = c(
        opt.tbreg(out_linear()$caption),
        list(columnDefs = list(list(visible = FALSE, targets = hide))),
        list(scrollX = TRUE)
      )
    ) \%>\% formatStyle("sig", target = "row", backgroundColor = styleEqual("**", "yellow"))
  })
}
}
