% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jskm.R
\name{jskm}
\alias{jskm}
\title{Creates a Kaplan-Meier plot for survfit object.}
\usage{
jskm(
  sfit,
  table = FALSE,
  table.censor = FALSE,
  xlabs = "Time-to-event",
  ylabs = NULL,
  xlims = c(0, max(sfit$time)),
  ylims = c(0, 1),
  surv.scale = c("default", "percent"),
  ystratalabs = NULL,
  ystrataname = "Strata",
  timeby = signif(max(sfit$time)/7, 1),
  main = "",
  pval = FALSE,
  pval.size = 5,
  pval.coord = c(NULL, NULL),
  pval.testname = T,
  marks = TRUE,
  shape = 3,
  med = FALSE,
  legend = TRUE,
  legendposition = c(0.85, 0.8),
  ci = FALSE,
  subs = NULL,
  label.nrisk = "Numbers at risk",
  size.label.nrisk = 10,
  linecols = "Set1",
  dashed = FALSE,
  cumhaz = F,
  cluster.option = "None",
  cluster.var = NULL,
  data = NULL,
  cut.landmark = NULL,
  showpercent = F,
  status.cmprsk = NULL,
  linewidth = 0.75,
  theme = NULL,
  nejm.infigure.ratiow = 0.6,
  nejm.infigure.ratioh = 0.5,
  nejm.infigure.xlim = NULL,
  nejm.infigure.ylim = c(0, 1),
  surv.by = NULL,
  nejm.surv.by = NULL,
  hr = FALSE,
  hr.size = 5,
  hr.coord = c(NULL, NULL),
  hr.testname = F,
  ...
)
}
\arguments{
\item{sfit}{a survfit object}

\item{table}{logical: Create a table graphic below the K-M plot, indicating at-risk numbers?}

\item{table.censor}{logical: Add numbers of censored in table graphic}

\item{xlabs}{x-axis label}

\item{ylabs}{y-axis label}

\item{xlims}{numeric: list of min and max for x-axis. Default = c(0,max(sfit$time))}

\item{ylims}{numeric: list of min and max for y-axis. Default = c(0,1)}

\item{surv.scale}{scale transformation of survival curves. Allowed values are "default" or "percent".}

\item{ystratalabs}{character list. A list of names for each strata. Default = names(sfit$strata)}

\item{ystrataname}{The legend name. Default = "Strata"}

\item{timeby}{numeric: control the granularity along the time-axis; defaults to 7 time-points. Default = signif(max(sfit$time)/7, 1)}

\item{main}{plot title}

\item{pval}{logical: add the pvalue to the plot?}

\item{pval.size}{numeric value specifying the p-value text size. Default is 5.}

\item{pval.coord}{numeric vector, of length 2, specifying the x and y coordinates of the p-value. Default values are NULL}

\item{pval.testname}{logical: add '(Log-rank)' text to p-value. Default = F}

\item{marks}{logical: should censoring marks be added?}

\item{shape}{what shape should the censoring marks be, default is a vertical line}

\item{med}{should a median line be added to the plot? Default = F}

\item{legend}{logical. should a legend be added to the plot?}

\item{legendposition}{numeric. x, y position of the legend if plotted. Default=c(0.85,0.8)}

\item{ci}{logical. Should confidence intervals be plotted. Default = FALSE}

\item{subs}{= NULL,}

\item{label.nrisk}{Numbers at risk label. Default = "Numbers at risk"}

\item{size.label.nrisk}{Font size of label.nrisk. Default = 10}

\item{linecols}{Character or Character vector. Colour brewer pallettes too colour lines. Default ="Set1", "black" for black with dashed line, character vector for the customization of line colors.}

\item{dashed}{logical. Should a variety of linetypes be used to identify lines. Default = FALSE}

\item{cumhaz}{Show cumulative incidence function, Default: F}

\item{cluster.option}{Cluster option for p value, Option: "None", "cluster", "frailty", Default: "None"}

\item{cluster.var}{Cluster variable}

\item{data}{select specific data - for reactive input, Default = NULL}

\item{cut.landmark}{cut-off for landmark analysis, Default = NULL}

\item{showpercent}{Shows the percentages on the right side.}

\item{status.cmprsk}{Status value when competing risk analysis, Default = 2nd level of status variable}

\item{linewidth}{Line witdh, Default = 0.75}

\item{theme}{Theme of the plot, Default = NULL, "nejm" for NEJMOA style, "jama" for JAMA style}

\item{nejm.infigure.ratiow}{Ratio of infigure width to total width, Default = 0.6}

\item{nejm.infigure.ratioh}{Ratio of infigure height to total height, Default = 0.5}

\item{nejm.infigure.xlim}{x-axis limit of infigure, Default = NULL}

\item{nejm.infigure.ylim}{y-axis limit of infigure, Default = c(0,1)}

\item{surv.by}{breaks unit in y-axis, default = NULL(ggplot default)}

\item{nejm.surv.by}{breaks unit in y-axis in nejm figure, default = NULL(ggplot default)}

\item{hr}{logical: add the hazard ratio to the plot?}

\item{hr.size}{numeric value specifying the HR text size. Default is 5.}

\item{hr.coord}{numeric vector, of length 2, specifying the x and y coordinates of the p-value. Default values are NULL}

\item{hr.testname}{logical: add '(Log-rank)' text to p-value. Default = F}

\item{...}{PARAM_DESCRIPTION}
}
\value{
Plot
}
\description{
Creates a Kaplan-Meier plot with at risk tables below for survfit object.
}
\details{
DETAILS
}
\examples{
library(survival)
data(colon)
fit <- survfit(Surv(time, status) ~ rx, data = colon)
jskm(fit, timeby = 500)
}
\author{
Jinseob Kim, but heavily modified version of a script created by Michael Way.
\url{https://github.com/michaelway/ggkm/}
I have packaged this function, added functions to namespace and included a range of new parameters.
}
