% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/solve-irr.R
\name{newton.raphson.root}
\alias{newton.raphson.root}
\title{A Newton Raphson root finder: finds x such that f(x) = 0}
\usage{
newton.raphson.root(f, guess = 0, lower = -Inf, upper = Inf,
  max.iter = 100, toler = 1e-06, convergence = 1e-08)
}
\arguments{
\item{f}{The function whose zero is to be found. An R function
object that takes one numeric argument and returns a list of
two components (value and gradient). In an IRR application,
these two components will be the NPV and the DV01/10000. In an
implied volatility application, the components will be the
option price and the vega. See also the examples below}

\item{guess}{The starting value (guess) from which the solver
starts searching for the IRR}

\item{lower}{The lower end of the interval within which to search
for the root}

\item{upper}{The upper end of the interval within which to search
for the root}

\item{max.iter}{The maximum number of iterations of the
Newton-Raphson procedure}

\item{toler}{The criterion to determine whether a zero has been
found. If the value of the function exceeds \code{toler} in
absolute value, then \code{NA} is returned with a warning}

\item{convergence}{The relative tolerance threshold used to
determine whether the Newton-Raphson procedure has
converged. The procedure terminates when the last step is less
than \code{convergence} times the current estimate of the
root. Convergence can take place to a non zero local
minimum. This is checked using the \code{toler} criterion
below}
}
\value{
The function returns \code{NA} under either of two conditions: (a)
the procedure did not converge after \code{max.iter} iterations,
or (b) the procedure converged but the function value is not zero
within the limits of \code{toler} at this point. The second
condition usually implies that the procedure has converged to a
non zero local minimum from which there is no downhill gradient.

If the iterations converge to a genuine root (within the limits of
\code{toler}), then it returns the root that was found.
}
\description{
The function newton.raphson.root is a general root finder which
can find the zero of any function whose derivative is available.
In this package, it is called by \code{\link{irr.solve}} and by
\code{\link{GenBSImplied}}. It can be used in other situations as
well - see the examples below.
}
\references{
The Newton Raphson solver was converted from C++ code
    in the \href{http://www.boost.org/}{Boost library}
}

