% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrt.R
\name{jrt}
\alias{jrt}
\title{Fit ordinal IRT models on judgment data and return factor scores and
statistics.}
\usage{
jrt(data, irt.model = "auto", summary = T,
  selection.criterion = "AICC", response.categories = "auto",
  remove.judges.with.unobserved.categories = F, additional.stats = F,
  method.factor.scores = "EAP", return.mean.scores = T,
  prefix.for.outputs = "Judgments", column.names = "Judge",
  maximum.iterations = 2000, convergence.threshold = 0.001,
  estimation.algorithm = "EM", status.verbose = F,
  estimation.package.warnings = F, digits = 3, plots = T,
  greyscale = F, progress.bar = T, method.item.fit = "X2",
  select.variables.that.contain = NULL, silent = F, debug = F)
}
\arguments{
\item{data}{A dataframe or matrix including the judgments to be scored. Note
that so far missing data are not supported. This is the only required
argument for the function.}

\item{irt.model}{A string value with the name of the model to fit. It can be:
 \itemize{
 \item{\code{"auto"} (default) or \code{NULL} : Empirically select the model
 based on an information criterion (see \code{selection.criterion} argument).
\item{Difference models (more or less constrained versions of the
Graded Response Model)}
\itemize{
 \item{\code{"GRM"}: Graded Response Model}
 \item{\code{"CGRM"}: Constrained Graded Response Model (equal discriminations)}
 \item{\code{"GrRSM"}: Graded Rating Scale Model (same category structures)}
 \item{\code{"CGrRSM"}: Constrained Graded Rating Scale Model (same category
 structures and equal discriminations)}
          }
 \item{Divide-by-total models (more or less constrained versions of the
Generalized Partial Credit Model)}
 \itemize{
 \item{\code{"GPCM"}: Generalized Partial Credit Model}
 \item{\code{"PCM"}: Partial Credit Model (equal discriminations)}
 \item{\code{"GRSM"}: Generalized Rating Scale Model (same
 category structures)}
 \item{\code{"RSM"}: Rating Scale Model (same category structures and
 equal discriminations)}
          }
          }}
 For convenience, models can also be called by their full names
 (e.g. \code{"Generalized Rating Scale Model"}
 or \code{"Generalized Rating Scale"} work.)\cr
 \itemize{
 \item{Note: Models where judges are constrained to same category structures (Graded Rating Scale Model,
 Constrained Graded Rating Scale Model, Generalized Rating Scale Model and Rating Scale Model) cannot be fit
 if judges have different observed categories. Judges with unobserved categories are automatically removed
 if these models are called. If the automatic model selection is used,
 these models are ignored in the comparison by default, but this behavior can
 be modified to removing judges in the comparison with \code{remove.judges.with.unobserved.categories = T}.}}}

\item{summary}{A logical to indicate if summary statistics should be
displayed as messages (default is \code{TRUE}).}

\item{selection.criterion}{A string with the criterion for the automatic
selection. The default is the Akaike Information Criterion corrected
(\code{AICC}), but other criteria may be used (\code{AIC}, \code{BIC} and
\code{SABIC}).}

\item{response.categories}{A numeric vector to indicate the possible score
values. For example, use \code{1:7} for a Likert-type score from 1 to 7.
The default, \code{auto} automatically detects the possible values based on
the dataset provided.}

\item{remove.judges.with.unobserved.categories}{A logical value to indicate whether to only keep the
judges with all categories observed (based on the \code{response.categories}
argument). The Rating Scale Model (RSM) and Graded Rating Scale Model
(GRSM) can only be estimated if the same categories are observed for all
judges. If set to \code{TRUE}, "incomplete judges" are removed only to fit
models that require it (RSM and GRSM), and for other models when they are compared to them (to allow
meaningful model comparisons). It defaults to \code{FALSE} to keep all the data available, and has no effect
if models that do not require "complete judges" are called.}

\item{additional.stats}{A logical to indicate whether to report other
("non-IRT") reliability statistics (based on computations from packages
`psych` and `irr`). Defaults to \code{FALSE}.}

\item{method.factor.scores}{A string to indicate the method used to compute
the factor scores. Bayesian methods (\code{EAP}, \code{MAP}) are
recommended. Defaults to Expected A Posteriori (\code{EAP}) based on a Standard
Normal \eqn{N(0,1)} prior distribution. Alternatively, Maximum A Posteriori
(\code{MAP}) with a Standard Normal \eqn{N(0,1)} prior may be used. Maximum
Likelihood (\code{ML}) is also possible (it is equivalent to using a
uniform prior), but it is discouraged as can produce -Inf and +Inf
factor scores (for which standard errors will be missing). Alternatively,
Weighted Likelihood Estimation (\code{WLE}) may be used.}

\item{return.mean.scores}{A logical to indicate whether to return the mean
scores in the output (defaults to \code{TRUE}).}

\item{prefix.for.outputs}{A character used as prefix to name the vectors in the
output data frames. Default is \code{"Judgments"}.}

\item{column.names}{A character to indicate the preferred name to give to a Judge. Defaults to \code{"Judge"}.}

\item{maximum.iterations}{A numeric indicating the maximum number of
iterations used to fit the model (default is \code{2000}).}

\item{convergence.threshold}{A numeric to indicate the threshold used to
tolerate convergence (default is \code{.001}). Reduce for increased
precision (but slower or non convergent results).}

\item{estimation.algorithm}{A string indicating the estimation algorithm. Can
notably be \code{EM} for Bock and Atkin's Expected-Maximization (default)
or \code{MHRM} for the Metropolis-Hastings Robbins-Monro algorithm (usually
slower for unidimensional models).}

\item{status.verbose}{A logical to indicate whether to output messages
indicating what the package is doing. Defaults to \code{FALSE}.}

\item{estimation.package.warnings}{A logical to indicate whether to output
the warnings and messages of the estimation package. Defaults to
\code{FALSE} for a cleaner output, but set to \code{TRUE} if experiencing
issues with the estimation.}

\item{digits}{A numeric to indicate the number of digits to round output
statistics by (default is \code{3}).}

\item{plots}{A logical to indicate whether to plot the total information plot
and judge category curves (\code{TRUE}, default) or not (\code{FALSE}).}

\item{greyscale}{A logical to indicate whether the plots should be in greyscale (\code{TRUE}) or color (\code{FALSE}, default).}

\item{progress.bar}{A logical to indicate whether to show a progress bar
during the automatic model selection. Defaults to \code{TRUE}.}

\item{method.item.fit}{A character value to indicate which fit statistic to use
for the item fit output. Passed to the \code{itemfit} function of the
\code{mirt} pacakge. Can be \code{S_X2}, \code{Zh}, \code{X2}, \code{G2},
\code{PV_Q1}, \code{PV_Q1}, \code{X2*}, \code{X2*_df}, \code{infit}. Note that some are not be computable if there are missing data.}

\item{select.variables.that.contain}{A character string to use as data the
variables in the original dataset that contain the string. Based on the
\code{select} function of \code{dplyr}. For example, if all your judgment
data includes "Rater", use "Rater" to filter your dataset here.}

\item{silent}{A logical (defaults to \code{FALSE}) to ask no output (no message or plot) but the \code{jrt} object.
This uses other parameters (\code{progress.bar}, \code{estimation.package.warnings},
\code{plots}, \code{summary}) in order to return a silent output.
Useful if only using the package for factor scoring, for example.}

\item{debug}{A logical to report debug messages (used in development).
Defaults to \code{FALSE}.}
}
\value{
An object of S4-class \code{jrt}. The factor scores can be accessed
  in slot \code{@output.data}.
}
\description{
This function automatically selects appropriate polytomous IRT
  models based on an information criterion (e.g. Corrected AIC), then returns
  factor scores, standard errors and various IRT psychometric information, as
  well as more traditionnal ("CTT") psychometric information. All IRT
  estimation procedures are executed with the package \code{mirt} (Chalmers,
  2012). The non-IRT procedures use packages \code{psych} and \code{irr}.
}
\examples{

# Simulate data with package mirt
# (6 judges, 300 productions, ordinal ratings from 1 to 5)
set.seed(123)
N <- 300
judges <- 6
diffs <- t(apply(matrix(runif(judges*4, .4, 5), judges), 1, cumsum))
d <- -(diffs - rowMeans(diffs)) + stats::rnorm(judges, mean = 0, sd= 1)
data <- mirt::simdata(matrix(rlnorm(judges,1,0)), d, N,
itemtype = 'graded') + 1
colnames(data) <- paste("Judge_", 1:dim(data)[2], sep = "")
data <- as.data.frame(data)
### --> See mirt documentation for details

# Fit models
fit <- jrt(data,
  irt.model = "GRM", # to manually select a model
  plots = FALSE) # to remove plots

# Extract the factor scores
fit@factor.scores # In a dataframe with standard errors
fit@factor.scores.vector # As a numeric vector

# See vignette for more options

}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response
Theory Package for the R Environment. \emph{Journal of Statistical Software,
48}(6), 1-29. \doi{10.18637/jss.v048.i06}

Myszkowski & Storme (in press). Judge Response Theory? A call to upgrade our psychometrical account of creativity judgments. \emph{Psychology of Aesthetics, Creativity and the Arts.} \doi{10.17605/OSF.IO/9WC34}
}
