% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maths.R
\name{maths}
\alias{ad}
\alias{do}
\alias{do_}
\alias{floorj}
\alias{lengthj}
\alias{map}
\alias{map_}
\alias{maths}
\alias{maxj}
\alias{maxj_}
\alias{minj}
\alias{minj_}
\alias{sqrtj}
\title{Math operations}
\usage{
do(.data, ...)

do_(.data, ..., .dots)

lengthj(.data)

sqrtj(.data)

floorj(.data)

minj(.data, ...)

minj_(.data, ..., .dots)

maxj(.data, ...)

maxj_(.data, ..., .dots)

ad(.data)

map(.data, ...)

map_(.data, ..., .dots)
}
\arguments{
\item{.data}{input. This can be JSON input, or an object of class
\code{jqr} that has JSON and query params combined, which is passed
from function to function when using the jqr DSL.}

\item{...}{Comma separated list of unquoted variable names}

\item{.dots}{Used to work around non-standard evaluation}

\item{dots}{dots}
}
\description{
Math operations
}
\examples{
# do math
jq('{"a": 7}', '.a + 1')
# adding null gives back same result
jq('{"a": 7}', '.a + null')
jq('{"a": 7}', '.a += 1')
'{"a": 7}' \%>\%  do(.a + 1)
# '{"a": 7}' \%>\%  do(.a += 1) # this doesn't work quite yet
'{"a": [1,2], "b": [3,4]}' \%>\%  do(.a + .b)
'{"a": [1,2], "b": [3,4]}' \%>\%  do(.a - .b)
'{"a": 3}' \%>\%  do(4 - .a)
'["xml", "yaml", "json"]' \%>\%  do('. - ["xml", "yaml"]')
'5' \%>\%  do(10 / . * 3)

# comparisons
'[5,4,2,7]' \%>\% index() \%>\% do(. < 4)
'[5,4,2,7]' \%>\% index() \%>\% do(. > 4)
'[5,4,2,7]' \%>\% index() \%>\% do(. <= 4)
'[5,4,2,7]' \%>\% index() \%>\% do(. >= 4)
'[5,4,2,7]' \%>\% index() \%>\% do(. == 4)
'[5,4,2,7]' \%>\% index() \%>\% do(. != 4)

# length
'[[1,2], "string", {"a":2}, null]' \%>\% index \%>\% lengthj

# sqrt
'9' \%>\% sqrtj

# floor
'3.14159' \%>\% floorj

# find minimum
'[5,4,2,7]' \%>\% minj
'[{"foo":1, "bar":14}, {"foo":2, "bar":3}]' \%>\% minj
'[{"foo":1, "bar":14}, {"foo":2, "bar":3}]' \%>\% minj(foo)
'[{"foo":1, "bar":14}, {"foo":2, "bar":3}]' \%>\% minj(bar)

# find maximum
'[5,4,2,7]' \%>\% maxj
'[{"foo":1, "bar":14}, {"foo":2, "bar":3}]' \%>\% maxj
'[{"foo":1, "bar":14}, {"foo":2, "bar":3}]' \%>\% maxj(foo)
'[{"foo":1, "bar":14}, {"foo":2, "bar":3}]' \%>\% maxj(bar)

# increment values
## requires special \% operators, they get escaped internally
'{"foo": 1}' \%>\% do(.foo \%+=\% 1)
'{"foo": 1}' \%>\% do(.foo \%-=\% 1)
'{"foo": 1}' \%>\% do(.foo \%*=\% 4)
'{"foo": 1}' \%>\% do(.foo \%/=\% 10)
'{"foo": 1}' \%>\% do(.foo \%//=\% 10)
### fix me - \%= doesn't work
# '{"foo": 1}' \%>\% do(.foo \%\%=\% 10)

# add
'["a","b","c"]' \%>\% ad
'[1, 2, 3]' \%>\% ad
'[]' \%>\% ad

# map
## as far as I know, this only works with numbers, thus it's
## in the maths section
'[1, 2, 3]' \%>\% map(.+1)
'[1, 2, 3]' \%>\% map(./1)
'[1, 2, 3]' \%>\% map(.*4)
}

