% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/switch_strict.R
\name{switch_strict}
\alias{switch_strict}
\title{Wrapper for `switch` that errors helpfully if no match is found}
\usage{
switch_strict(EXPR, ..., .empty = NULL, .default = NULL)
}
\arguments{
\item{EXPR}{[string] expression to evaluate}

\item{...}{named options to match against EXPR}

\item{.empty}{[any: default NULL] value to return if EXPR is an empty string ("")}

\item{.default}{[any: default NULL] value to return if no match is found - NULL allows no defaults (strict)}
}
\value{
[any] the value of the matched option
}
\description{
Options for handling empty string ("") and no match cases
- no case matching is not allowed by default (hence 'strict')
}
\keyword{internal}
