\name{jedi}
\alias{jedi}
\title{Approximate non-orthogonal joint diagonalization of a set of square
real-valued matrices}
\description{
This function performs a Joint Approximate Diagonalization of a set of
square and real-valued matrices (not necessarily symmetric). 
The algorithm seeks the inverse of the joint
diagonalizer (the mixing matrix in terms of source separation).

The algorithm uses Givens and hyperbolic rotations to find the inverse of 
a non-orthogonal joint diagonalizer. It is an extension of the
JADE method (orthogonal joint diagonalization). 
}
\usage{
jedi(M, A0 = NULL, eps = .Machine$double.eps, itermax = 200, keepTrace = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{M}{DOUBLE ARRAY (KxKxN). Three-dimensional array with dimensions 
KxKxN representing the set
of square and real-valued matrices to be jointly diagonalized. 
N is the number of matrices. Matrices
are KxK square matrices.}
  \item{A0}{DOUBLE MATRIX (KxK). The initial guess of the inverse of a joint 
diagonalizer. If NULL, an initial
guess is automatically generated by the algorithm.}
  \item{eps}{DOUBLE. The algorithm stops when the criterium difference 
between two
iterations is less than eps.}
  \item{itermax}{INTEGER. Alternatively, the algorithm stops when itermax 
sweeps have
been performed without reaching convergence. If the maximum number of
iteration is performed, a warning appears.}
  \item{keepTrace}{BOOLEAN. Do we want to keep the successive estimations of 
the joint diagonalizer.}
}
\details{
  Given a set \eqn{M_i} of \code{N} \code{K \times K} square and
real-valued matrices, the
algorithm is looking for a matrix \eqn{A} such that
\eqn{\forall i \in [1,N]}, \eqn{A^{-1} C_i A^{-T}} is as close as possible of a
diagonal matrix. 
}
\value{
  \item{A}{Estimation of the Joint Diagonalizer.}
  \item{criter}{Successive estimates of the cost function across sweeps.}
  \item{A_trace}{Array of the successive estimates of A across iterations.}
}
\references{Souloumiac, A.; Non-Orthogonal Joint Diagonalization by Combining
Givens and Hyperbolic Rotations; IEEE Trans. Signal Process., 2009}
\author{Cedric Gouy-Pailler (cedric.gouypailler@gmail.com),
with help from Antoine Souloumiac.}
\section{Warning }{
This algorithm based on a combination of givens and hyperbolic rotations is
covered by a patent (see A. Souloumiac, CEA Saclay).
}
\examples{
# generating diagonal matrices
D <- replicate(30, diag(rchisq(df=1,n=10)), simplify=FALSE)
# Mixing and demixing matrices
B <- matrix(rnorm(100),10,10)
A <- solve(B)
C <- array(NA,dim=c(10,10,30))
for (i in 1:30) C[,,i] <- A \%*\% D[[i]] \%*\% t(A)
A_est <- jedi(C)$A
# A_est should be an approximate of A
B \%*\% A_est
# close to a permutation matrix (with random scales)
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{algebra}
