% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{weights.joinet}
\alias{weights.joinet}
\title{Extract Weights}
\usage{
\method{weights}{joinet}(object, ...)
}
\arguments{
\item{object}{\link[joinet]{joinet} object}

\item{...}{further arguments (not applicable)}
}
\value{
This function returns a matrix with
\eqn{1+q} rows and \eqn{q} columns.
The first row contains the intercepts,
and the other rows contain the slopes,
which are the effects of the outcomes
in the row on the outcomes in the column.
}
\description{
Extracts coefficients from the meta learner,
i.e. the weights for the base learners.
}
\examples{
\dontshow{
if(!grepl('SunOS',Sys.info()['sysname'])){
n <- 50; p <- 100; q <- 3
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
Y <- replicate(n=q,expr=rnorm(n=n,mean=rowSums(X[,1:5])))
object <- joinet(Y=Y,X=X)
weights(object)}}
\dontrun{
n <- 50; p <- 100; q <- 3
X <- matrix(rnorm(n*p),nrow=n,ncol=p)
Y <- replicate(n=q,expr=rnorm(n=n,mean=rowSums(X[,1:5])))
object <- joinet(Y=Y,X=X)
weights(object)}

}
