test_that("arrange_cols_omv works", {
    set.seed(1)
    tmpDF <- stats::setNames(as.data.frame(matrix(sample(6, 1200, replace = TRUE), nrow = 16)), sprintf("sbj_%03d", seq(75)))
    nmeInp <- tempfile(fileext = ".rds")
    nmeOut <- tempfile(fileext = "_T.omv")
    saveRDS(tmpDF, nmeInp)

    expect_null(transpose_omv(dtaInp = tmpDF, fleOut = nmeOut))
    expect_true(chkFle(nmeOut))
    expect_gt(file.info(nmeOut)$size, 1)
    expect_true(chkFle(nmeOut, isZIP = TRUE))
    expect_true(chkFle(nmeOut, fleCnt = "meta"))
    expect_true(chkFle(nmeOut, fleCnt = "metadata.json"))
    expect_true(chkFle(nmeOut, fleCnt = "data.bin"))
    df4Chk <- read_omv(nmeOut, sveAtt = FALSE)
    expect_s3_class(df4Chk, "data.frame")
    expect_equal(dim(df4Chk), c(75, 17))
    expect_equal(names(df4Chk), c("ID", sprintf("V_%d", seq(16))))
    expect_equal(vapply(df4Chk, typeof, character(1), USE.NAMES = FALSE), c("character", rep("integer", 16)))
    unlink(nmeOut)

    expect_null(transpose_omv(dtaInp = cbind(list(qstItm = sprintf("Qst_%02d", seq(16))), tmpDF), fleOut = nmeOut, varNme = "qstItm"))
    expect_true(chkFle(nmeOut))
    expect_gt(file.info(nmeOut)$size, 1)
    expect_true(chkFle(nmeOut, isZIP = TRUE))
    expect_true(chkFle(nmeOut, fleCnt = "meta"))
    expect_true(chkFle(nmeOut, fleCnt = "metadata.json"))
    expect_true(chkFle(nmeOut, fleCnt = "data.bin"))
    df4Chk <- read_omv(nmeOut, sveAtt = FALSE)
    expect_s3_class(df4Chk, "data.frame")
    expect_equal(dim(df4Chk), c(75, 17))
    expect_equal(names(df4Chk), c("ID", sprintf("Qst_%02d", seq(16))))
    expect_equal(vapply(df4Chk, typeof, character(1), USE.NAMES = FALSE), c("character", rep("integer", 16)))
    unlink(nmeOut)

    expect_null(transpose_omv(dtaInp = tmpDF, fleOut = nmeOut, varNme = sprintf("Trl_%02d", seq(16))))
    expect_true(chkFle(nmeOut))
    expect_gt(file.info(nmeOut)$size, 1)
    expect_true(chkFle(nmeOut, isZIP = TRUE))
    expect_true(chkFle(nmeOut, fleCnt = "meta"))
    expect_true(chkFle(nmeOut, fleCnt = "metadata.json"))
    expect_true(chkFle(nmeOut, fleCnt = "data.bin"))
    df4Chk <- read_omv(nmeOut, sveAtt = FALSE)
    expect_s3_class(df4Chk, "data.frame")
    expect_equal(dim(df4Chk), c(75, 17))
    expect_equal(names(df4Chk), c("ID", sprintf("Trl_%02d", seq(16))))
    expect_equal(vapply(df4Chk, typeof, character(1), USE.NAMES = FALSE), c("character", rep("integer", 16)))
    unlink(nmeOut)

    expect_null(transpose_omv(dtaInp = nmeInp, fleOut = nmeOut))
    expect_true(chkFle(nmeOut))
    expect_gt(file.info(nmeOut)$size, 1)
    expect_true(chkFle(nmeOut, isZIP = TRUE))
    expect_true(chkFle(nmeOut, fleCnt = "meta"))
    expect_true(chkFle(nmeOut, fleCnt = "metadata.json"))
    expect_true(chkFle(nmeOut, fleCnt = "data.bin"))
    df4Chk <- read_omv(nmeOut, sveAtt = FALSE)
    expect_s3_class(df4Chk, "data.frame")
    expect_equal(dim(df4Chk), c(75, 17))
    expect_equal(names(df4Chk), c("ID", sprintf("V_%d", seq(16))))
    expect_equal(vapply(df4Chk, typeof, character(1), USE.NAMES = FALSE), c("character", rep("integer", 16)))
    unlink(nmeOut)

    df4Chk <- transpose_omv(dtaInp = tmpDF)
    expect_s3_class(df4Chk, "data.frame")
    expect_equal(dim(df4Chk), c(75, 17))
    expect_equal(names(df4Chk), c("ID", sprintf("V_%d", seq(16))))
    expect_equal(vapply(df4Chk, typeof, character(1), USE.NAMES = FALSE), c("character", rep("integer", 16)))

    expect_error(transpose_omv(fleInp = tmpDF, fleOut = nmeOut), regexp = "Please use the argument dtaInp instead of fleInp\\.")
    unlink(nmeInp)


    expect_error(transpose_omv(dtaInp = tmpDF, fleOut = nmeOut, varNme = "notExist"),
      regexp = "^.*\\(varNme\\) not contained in the input data frame\\.")
    expect_error(transpose_omv(dtaInp = tmpDF, fleOut = nmeOut, varNme = 1), regexp = "^varNme must be a character variable\\.")
    expect_error(transpose_omv(dtaInp = tmpDF, fleOut = nmeOut, varNme = c("Qst_01", "Qst_02")),
      regexp = "^varNme must either be empty, have one element or as many elements as there are rows in the input data frame\\.")
})
