
# This file is automatically generated, you probably don't want to edit this

linRegOptions <- if (requireNamespace('jmvcore')) R6::R6Class(
    "linRegOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            dep = NULL,
            blocks = list(
                list()),
            fitMeasures = list(
                "r",
                "r2"),
            modelTest = NULL,
            modelComp = list(
                "f"),
            stdEst = FALSE,
            ci = FALSE,
            ciWidth = 95,
            coefPlot = FALSE,
            qqPlot = FALSE,
            resPlots = FALSE,
            durbin = FALSE,
            collin = FALSE,
            desc = FALSE,
            cooks = FALSE,
            modelSelected = -1, ...) {

            super$initialize(
                package='jmv',
                name='linReg',
                requiresData=TRUE,
                ...)

            private$..dep <- jmvcore::OptionVariable$new(
                "dep",
                dep,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "continuous",
                    "nominal",
                    "ordinal"))
            private$..blocks <- jmvcore::OptionArray$new(
                "blocks",
                blocks,
                default=list(
                    list()),
                template=jmvcore::OptionVariables$new(
                    "blocks",
                    NULL,
                    suggested=list(
                        "continuous"),
                    permitted=list(
                        "continuous",
                        "nominal",
                        "ordinal")))
            private$..fitMeasures <- jmvcore::OptionNMXList$new(
                "fitMeasures",
                fitMeasures,
                options=list(
                    "r",
                    "r2",
                    "r2Adj",
                    "aic",
                    "bic",
                    "rmse"),
                default=list(
                    "r",
                    "r2"))
            private$..modelTest <- jmvcore::OptionNMXList$new(
                "modelTest",
                modelTest,
                options=list(
                    "f",
                    "bf"),
                default=NULL)
            private$..modelComp <- jmvcore::OptionNMXList$new(
                "modelComp",
                modelComp,
                options=list(
                    "f",
                    "bf"),
                default=list(
                    "f"))
            private$..stdEst <- jmvcore::OptionBool$new(
                "stdEst",
                stdEst,
                default=FALSE)
            private$..ci <- jmvcore::OptionBool$new(
                "ci",
                ci,
                default=FALSE)
            private$..ciWidth <- jmvcore::OptionNumber$new(
                "ciWidth",
                ciWidth,
                min=50,
                max=99.9,
                default=95)
            private$..coefPlot <- jmvcore::OptionBool$new(
                "coefPlot",
                coefPlot,
                default=FALSE)
            private$..qqPlot <- jmvcore::OptionBool$new(
                "qqPlot",
                qqPlot,
                default=FALSE)
            private$..resPlots <- jmvcore::OptionBool$new(
                "resPlots",
                resPlots,
                default=FALSE)
            private$..durbin <- jmvcore::OptionBool$new(
                "durbin",
                durbin,
                default=FALSE)
            private$..collin <- jmvcore::OptionBool$new(
                "collin",
                collin,
                default=FALSE)
            private$..desc <- jmvcore::OptionBool$new(
                "desc",
                desc,
                default=FALSE)
            private$..cooks <- jmvcore::OptionBool$new(
                "cooks",
                cooks,
                default=FALSE)
            private$..modelSelected <- jmvcore::OptionInteger$new(
                "modelSelected",
                modelSelected,
                default=-1,
                hidden=TRUE)

            self$.addOption(private$..dep)
            self$.addOption(private$..blocks)
            self$.addOption(private$..fitMeasures)
            self$.addOption(private$..modelTest)
            self$.addOption(private$..modelComp)
            self$.addOption(private$..stdEst)
            self$.addOption(private$..ci)
            self$.addOption(private$..ciWidth)
            self$.addOption(private$..coefPlot)
            self$.addOption(private$..qqPlot)
            self$.addOption(private$..resPlots)
            self$.addOption(private$..durbin)
            self$.addOption(private$..collin)
            self$.addOption(private$..desc)
            self$.addOption(private$..cooks)
            self$.addOption(private$..modelSelected)
        }),
    active = list(
        dep = function() private$..dep$value,
        blocks = function() private$..blocks$value,
        fitMeasures = function() private$..fitMeasures$value,
        modelTest = function() private$..modelTest$value,
        modelComp = function() private$..modelComp$value,
        stdEst = function() private$..stdEst$value,
        ci = function() private$..ci$value,
        ciWidth = function() private$..ciWidth$value,
        coefPlot = function() private$..coefPlot$value,
        qqPlot = function() private$..qqPlot$value,
        resPlots = function() private$..resPlots$value,
        durbin = function() private$..durbin$value,
        collin = function() private$..collin$value,
        desc = function() private$..desc$value,
        cooks = function() private$..cooks$value,
        modelSelected = function() private$..modelSelected$value),
    private = list(
        ..dep = NA,
        ..blocks = NA,
        ..fitMeasures = NA,
        ..modelTest = NA,
        ..modelComp = NA,
        ..stdEst = NA,
        ..ci = NA,
        ..ciWidth = NA,
        ..coefPlot = NA,
        ..qqPlot = NA,
        ..resPlots = NA,
        ..durbin = NA,
        ..collin = NA,
        ..desc = NA,
        ..cooks = NA,
        ..modelSelected = NA)
)

linRegResults <- if (requireNamespace('jmvcore')) R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        modelFit = function() private$.items[["modelFit"]],
        modelComp = function() private$.items[["modelComp"]],
        coef = function() private$.items[["coef"]],
        coefPlot = function() private$.items[["coefPlot"]],
        dataSummary = function() private$.items[["dataSummary"]],
        assump = function() private$.items[["assump"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="Linear Regression")
            self$add(jmvcore::Table$new(
                options=options,
                name="modelFit",
                title="Model Fit Measures",
                rowSelect="(modelSelected)",
                clearWith=list(
                    "dep",
                    "blocks"),
                columns=list(
                    list(
                        `name`="model", 
                        `title`="Model", 
                        `type`="text"),
                    list(
                        `name`="r", 
                        `title`="R", 
                        `type`="number", 
                        `visible`="(fitMeasures:r)"),
                    list(
                        `name`="r2", 
                        `title`="R\u00B2", 
                        `type`="number", 
                        `visible`="(fitMeasures:r2)"),
                    list(
                        `name`="r2Adj", 
                        `title`="Adjusted R\u00B2", 
                        `type`="number", 
                        `visible`="(fitMeasures:r2Adj)"),
                    list(
                        `name`="aic", 
                        `title`="AIC", 
                        `type`="number", 
                        `visible`="(fitMeasures:aic)"),
                    list(
                        `name`="bic", 
                        `title`="BIC", 
                        `type`="number", 
                        `visible`="(fitMeasures:bic)"),
                    list(
                        `name`="rmse", 
                        `title`="RMSE", 
                        `type`="number", 
                        `visible`="(fitMeasures:rmse)"),
                    list(
                        `name`="f", 
                        `title`="F", 
                        `type`="number", 
                        `superTitle`="Overall Model Test", 
                        `visible`="(modelTest:f)"),
                    list(
                        `name`="df1", 
                        `title`="df1", 
                        `type`="integer", 
                        `superTitle`="Overall Model Test", 
                        `visible`="(modelTest:f)"),
                    list(
                        `name`="df2", 
                        `title`="df2", 
                        `type`="integer", 
                        `superTitle`="Overall Model Test", 
                        `visible`="(modelTest:f)"),
                    list(
                        `name`="p", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `superTitle`="Overall Model Test", 
                        `visible`="(modelTest:f)"),
                    list(
                        `name`="bf", 
                        `title`="BF\u2081\u2080", 
                        `type`="number", 
                        `superTitle`="Overall Model Test", 
                        `visible`="(modelTest:bf)"),
                    list(
                        `name`="err", 
                        `title`="\u00B1%", 
                        `type`="number", 
                        `superTitle`="Overall Model Test", 
                        `visible`="(modelTest:bf)"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="modelComp",
                title="Model Comparisons",
                clearWith=list(
                    "dep",
                    "blocks"),
                columns=list(
                    list(
                        `name`="model1", 
                        `title`="Model", 
                        `content`=".", 
                        `type`="text", 
                        `superTitle`="Comparison"),
                    list(
                        `name`="sep", 
                        `title`="", 
                        `content`="-", 
                        `type`="text", 
                        `format`="narrow", 
                        `superTitle`="Comparison"),
                    list(
                        `name`="model2", 
                        `title`="Model", 
                        `content`=".", 
                        `type`="text", 
                        `superTitle`="Comparison"),
                    list(
                        `name`="r2", 
                        `title`="\u0394R\u00B2", 
                        `type`="number"),
                    list(
                        `name`="f", 
                        `title`="F", 
                        `type`="number", 
                        `visible`="(modelComp:f)"),
                    list(
                        `name`="df1", 
                        `title`="df1", 
                        `type`="integer", 
                        `visible`="(modelComp:f)"),
                    list(
                        `name`="df2", 
                        `title`="df2", 
                        `type`="integer", 
                        `visible`="(modelComp:f)"),
                    list(
                        `name`="p", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue", 
                        `visible`="(modelComp:f)"),
                    list(
                        `name`="bf", 
                        `title`="BF\u2081\u2080", 
                        `type`="number", 
                        `visible`="(modelComp:bf)"),
                    list(
                        `name`="err", 
                        `title`="\u00B1%", 
                        `type`="number", 
                        `visible`="(modelComp:bf)"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="coef",
                title="Model Coefficients",
                clearWith=list(
                    "dep",
                    "blocks"),
                columns=list(
                    list(
                        `name`="model", 
                        `title`="Model", 
                        `type`="text", 
                        `combineBelow`=TRUE),
                    list(
                        `name`="terms", 
                        `title`="Predictor", 
                        `type`="text"),
                    list(
                        `name`="est", 
                        `title`="Estimate", 
                        `type`="number"),
                    list(
                        `name`="se", 
                        `title`="SE", 
                        `type`="number"),
                    list(
                        `name`="lower", 
                        `title`="Lower", 
                        `type`="number", 
                        `visible`="(ci)"),
                    list(
                        `name`="upper", 
                        `title`="Upper", 
                        `type`="number", 
                        `visible`="(ci)"),
                    list(
                        `name`="stdEst", 
                        `title`="Stand. Estimate", 
                        `type`="number", 
                        `visible`="(stdEst)"),
                    list(
                        `name`="t", 
                        `title`="t", 
                        `type`="number"),
                    list(
                        `name`="p", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue"))))
            self$add(jmvcore::Image$new(
                options=options,
                name="coefPlot",
                title="Coefficient Plot",
                width=550,
                height=500,
                renderFun=".coefPlot",
                visible="(coefPlot)",
                clearWith=list(
                    "dep",
                    "blocks",
                    "modelSelected",
                    "ciWidth")))
            self$add(R6::R6Class(
                inherit = jmvcore::Group,
                active = list(
                    desc = function() private$.items[["desc"]],
                    cooks = function() private$.items[["cooks"]]),
                private = list(),
                public=list(
                    initialize=function(options) {
                        super$initialize(
                            options=options,
                            name="dataSummary",
                            title="Data Summary")
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="desc",
                            title="Descriptives",
                            visible="(desc)",
                            clearWith=list(
                                "dep",
                                "blocks",
                                "modelSelected"),
                            columns=list(
                                list(
                                    `name`="name", 
                                    `title`="", 
                                    `type`="text"),
                                list(
                                    `name`="num", 
                                    `title`="N", 
                                    `type`="number"),
                                list(
                                    `name`="mean", 
                                    `title`="Mean", 
                                    `type`="number"),
                                list(
                                    `name`="median", 
                                    `title`="Median", 
                                    `type`="number"),
                                list(
                                    `name`="sd", 
                                    `title`="SD", 
                                    `type`="number"),
                                list(
                                    `name`="se", 
                                    `title`="SE", 
                                    `type`="number"))))
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="cooks",
                            title="Cook's Distance",
                            rows=1,
                            visible="(cooks)",
                            clearWith=list(
                                "dep",
                                "blocks",
                                "modelSelected"),
                            columns=list(
                                list(
                                    `name`="mean", 
                                    `title`="Mean", 
                                    `type`="number"),
                                list(
                                    `name`="median", 
                                    `title`="Median", 
                                    `type`="number"),
                                list(
                                    `name`="sd", 
                                    `title`="SD", 
                                    `type`="number"),
                                list(
                                    `name`="min", 
                                    `title`="Min", 
                                    `type`="number", 
                                    `superTitle`="Range"),
                                list(
                                    `name`="max", 
                                    `title`="Max", 
                                    `type`="number", 
                                    `superTitle`="Range"))))}))$new(options=options))
            self$add(R6::R6Class(
                inherit = jmvcore::Group,
                active = list(
                    durbin = function() private$.items[["durbin"]],
                    collin = function() private$.items[["collin"]],
                    qqPlot = function() private$.items[["qqPlot"]],
                    resPlots = function() private$.items[["resPlots"]]),
                private = list(),
                public=list(
                    initialize=function(options) {
                        super$initialize(
                            options=options,
                            name="assump",
                            title="Assumption Checks")
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="durbin",
                            title="Durbin\u2013Watson Test for Autocorrelation",
                            rows=1,
                            visible="(durbin)",
                            clearWith=list(
                                "dep",
                                "blocks",
                                "modelSelected"),
                            columns=list(
                                list(
                                    `name`="autoCor", 
                                    `title`="Autocorrelation", 
                                    `type`="number"),
                                list(
                                    `name`="dw", 
                                    `title`="DW Statistic", 
                                    `type`="number"),
                                list(
                                    `name`="p", 
                                    `title`="p", 
                                    `type`="number", 
                                    `format`="zto,pvalue"))))
                        self$add(jmvcore::Table$new(
                            options=options,
                            name="collin",
                            title="Collinearity Statistics",
                            visible="(collin)",
                            clearWith=list(
                                "dep",
                                "blocks",
                                "modelSelected"),
                            columns=list(
                                list(
                                    `name`="term", 
                                    `title`="", 
                                    `type`="text"),
                                list(
                                    `name`="vif", 
                                    `title`="VIF", 
                                    `type`="number"),
                                list(
                                    `name`="tol", 
                                    `title`="Tolerance", 
                                    `type`="number"))))
                        self$add(jmvcore::Image$new(
                            options=options,
                            name="qqPlot",
                            title="Q-Q Plot",
                            width=450,
                            height=400,
                            renderFun=".qqPlot",
                            visible="(qqPlot)",
                            clearWith=list(
                                "dep",
                                "blocks",
                                "modelSelected")))
                        self$add(jmvcore::Array$new(
                            options=options,
                            name="resPlots",
                            title="Residuals Plots",
                            visible="(resPlots)",
                            template=jmvcore::Image$new(
                                options=options,
                                renderFun=".resPlot",
                                clearWith=list(
                                    "dep",
                                    "blocks",
                                    "modelSelected"))))}))$new(options=options))}))

linRegBase <- if (requireNamespace('jmvcore')) R6::R6Class(
    "linRegBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'linReg',
                version = c(1,0,0),
                options = options,
                results = linRegResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = FALSE)
        }))

#' Linear Regression
#'
#' Linear Regression
#'
#' @examples
#' data('Prestige', package='car')
#'
#' linReg(data = Prestige, dep = 'income',
#'        blocks = list(c('education', 'prestige', 'women')))
#'
#' #
#' #  Model Fit Measures
#' #  ---------------------------
#' #    Model    R        R²
#' #  ---------------------------
#' #    1        0.802    0.643
#' #  ---------------------------
#' #
#' #
#' #
#' #  Model Coefficients
#' #  -----------------------------------------------------------------
#' #    Model    Predictor    Estimate    SE         t         p
#' #  -----------------------------------------------------------------
#' #    1        Intercept      -253.8    1086.16    -0.234     0.816
#' #             education       177.2     187.63     0.944     0.347
#' #             prestige        141.4      29.91     4.729    < .001
#' #             women           -50.9       8.56    -5.948    < .001
#' #  -----------------------------------------------------------------
#' #
#'
#' @param data the data as a data frame
#' @param dep a string naming the dependent variable from \code{data},
#'   variable must be numeric
#' @param blocks a list containing vectors of strings that name the covariates
#'   that are added to the model. The elements are added to the model according
#'   to their order in the list
#' @param fitMeasures one or more of \code{'r'}, \code{'r2'}, \code{'r2Adj'},
#'   \code{'aic'}, \code{'bic'}, or \code{'rmse'}; use R, R², adjusted R², AIC,
#'   BIC, and RMSE model fit measures, respectively
#' @param modelTest one or more of \code{'f'}, or \code{'bf'}; Use classical
#'   F-test, and Bayes factor respectively as overall model tests.
#' @param modelComp one or more of \code{'f'}, or \code{'bf'}; Use classical
#'   F-test, and Bayes factor respectively as model comparison tests.
#' @param stdEst \code{TRUE} or \code{FALSE} (default), provide a standardized
#'   estimate for the model coefficients
#' @param ci \code{TRUE} or \code{FALSE} (default), provide a confidence
#'   interval for the model coefficients
#' @param ciWidth a number between 50 and 99.9 (default: 95) specifying the
#'   confidence interval width
#' @param coefPlot \code{TRUE} or \code{FALSE} (default), provide a
#'   coefficient plot where for each predictor the estimated coefficient and
#'   confidence intervals are plotted.
#' @param qqPlot \code{TRUE} or \code{FALSE} (default), provide a Q-Q plot of
#'   residuals
#' @param resPlots \code{TRUE} or \code{FALSE} (default), provide residual
#'   plots where the dependent variable and each covariate is plotted against
#'   the standardized residuals.
#' @param durbin \code{TRUE} or \code{FALSE} (default), provide results of the
#'   Durbin- Watson test for autocorrelation
#' @param collin \code{TRUE} or \code{FALSE} (default), provide VIF and
#'   tolerence collinearity statistics
#' @param desc \code{TRUE} or \code{FALSE} (default), provide descriptive
#'   statistics
#' @param cooks \code{TRUE} or \code{FALSE} (default), provide summary
#'   statistics for the Cook's distance
#' @param modelSelected an integer defining the model for which the model
#'   specific output needs to be calculated (defaults to most complex model)
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$modelFit} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$modelComp} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$coef} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$coefPlot} \tab \tab \tab \tab \tab an image \cr
#'   \code{results$dataSummary$desc} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$dataSummary$cooks} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$assump$durbin} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$assump$collin} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$assump$qqPlot} \tab \tab \tab \tab \tab an image \cr
#'   \code{results$assump$resPlots} \tab \tab \tab \tab \tab an array \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$modelFit$asDF}
#'
#' \code{as.data.frame(results$modelFit)}
#'
#' @export
linReg <- function(
    data,
    dep,
    blocks = list(
                list()),
    fitMeasures = list(
                "r",
                "r2"),
    modelTest = NULL,
    modelComp = list(
                "f"),
    stdEst = FALSE,
    ci = FALSE,
    ciWidth = 95,
    coefPlot = FALSE,
    qqPlot = FALSE,
    resPlots = FALSE,
    durbin = FALSE,
    collin = FALSE,
    desc = FALSE,
    cooks = FALSE,
    modelSelected = -1) {

    if ( ! requireNamespace('jmvcore'))
        stop('linReg requires jmvcore to be installed (restart may be required)')

    options <- linRegOptions$new(
        dep = dep,
        blocks = blocks,
        fitMeasures = fitMeasures,
        modelTest = modelTest,
        modelComp = modelComp,
        stdEst = stdEst,
        ci = ci,
        ciWidth = ciWidth,
        coefPlot = coefPlot,
        qqPlot = qqPlot,
        resPlots = resPlots,
        durbin = durbin,
        collin = collin,
        desc = desc,
        cooks = cooks,
        modelSelected = modelSelected)

    results <- linRegResults$new(
        options = options)

    analysis <- linRegClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
