% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anovarmnp.h.R
\name{anovaRMNP}
\alias{anovaRMNP}
\title{Repeated Measures ANOVA (Non-parametric)}
\usage{
anovaRMNP(data, measures, pairs = FALSE, desc = FALSE, plots = FALSE,
  plotType = "means")
}
\arguments{
\item{data}{the data as a data frame}

\item{measures}{a vector of strings naming the repeated measures variables}

\item{pairs}{\code{TRUE} or \code{FALSE} (default), perform pairwise 
comparisons}

\item{desc}{\code{TRUE} or \code{FALSE} (default), provide descriptive 
statistics}

\item{plots}{\code{TRUE} or \code{FALSE} (default), provide a descriptive 
plot}

\item{plotType}{\code{'means'} (default) or \code{'medians'}, the error 
bars to use in the plot}
}
\description{
Friedman
}
\examples{
\dontrun{
data('bugs', package = 'jmv')

anovaRMNP(bugs, measures = c('LDLF', 'LDHF', 'HDLF', 'HDHF'))

#
#  Friedman
#  ------------------------
#    X²      df    p
#  ------------------------
#    55.8     3    < .001
#  ------------------------
#
}
}
