% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efa.h.R
\name{efa}
\alias{efa}
\title{Exploratory Factor Analysis}
\usage{
efa(data, vars, nFactorMethod = "parallel", nFactors = 1, minEigen = 1,
  rotation = "oblimin", hideLoadings = 0.3, screePlot = FALSE,
  eigenValues = FALSE, factorCor = FALSE, factorSummary = FALSE,
  modelFit = FALSE, kmoTest = FALSE, bartlettTest = FALSE)
}
\arguments{
\item{data}{.}

\item{vars}{a vector of strings naming the variables of interest in 
\code{data}}

\item{nFactorMethod}{\code{'parallel'} (default), \code{'eigen'} or 
\code{'fixed'}, the way to determine the number of factors}

\item{nFactors}{an integer (default: 1), the number of factors in the model}

\item{minEigen}{a number (default: 1), the minimal eigenvalue for a factor 
to be included in the model}

\item{rotation}{\code{'none'}, \code{'varimax'} (default), 
\code{'quartimax'}, \code{'promax'}, \code{'oblimin'}, or 
\code{'simplimax'}, the rotation to use in estimation}

\item{hideLoadings}{a number (default: 0.3), hide loadings below this value}

\item{screePlot}{\code{TRUE} or \code{FALSE} (default), show scree plot}

\item{eigenValues}{\code{TRUE} or \code{FALSE} (default), show eigenvalue 
table}

\item{factorCor}{\code{TRUE} or \code{FALSE} (default), show factor 
correlations}

\item{factorSummary}{\code{TRUE} or \code{FALSE} (default), show factor 
summary}

\item{modelFit}{\code{TRUE} or \code{FALSE} (default), show model fit 
measures and test}

\item{kmoTest}{\code{TRUE} or \code{FALSE} (default), show 
Kaiser-Meyer-Olkin (KMO) measure of sampling adequacy (MSA) results}

\item{bartlettTest}{\code{TRUE} or \code{FALSE} (default), show Bartlett's 
test of sphericity results}
}
\description{
Exporatory Factor Analysis
}
\examples{
data('iris')
dat <- as.data.frame(iris)

jmv::efa(data = dat, vars = c('Sepal.Length', 'Sepal.Width', 'Petal.Length', 'Petal.Width'))

#
#  Factor Loadings
#  -------------------------------------------------
#                    1        2         Uniqueness
#  -------------------------------------------------
#    Sepal.Length    0.948                 0.10181
#    Sepal.Width              -0.747       0.42199
#    Petal.Length    0.917     0.394       0.00483
#    Petal.Width     0.883     0.388       0.07088
#  -------------------------------------------------
#    Note. 'varimax' rotation was used
#
#

}
